/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeParameter;
import com.facebook.presto.common.type.VarcharType;
import java.util.List;

public class VarcharParametricType
implements ParametricType {
    public static final VarcharParametricType VARCHAR = new VarcharParametricType();

    public String getName() {
        return "varchar";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return VarcharType.createUnboundedVarcharType();
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one parameter for VARCHAR");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("VARCHAR length must be a number");
        }
        long length = parameter.getLongLiteral();
        if (length == Integer.MAX_VALUE) {
            return VarcharType.createUnboundedVarcharType();
        }
        if (length < 0L || length > 0x7FFFFFFEL) {
            throw new IllegalArgumentException("Invalid VARCHAR length " + length);
        }
        return VarcharType.createVarcharType((int)((int)length));
    }
}

