/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.GroupedAccumulatorState;
import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import com.facebook.presto.type.khyperloglog.KHyperLogLogState;
import org.openjdk.jol.info.ClassLayout;

public class KHyperLogLogStateFactory
implements AccumulatorStateFactory<KHyperLogLogState> {
    private static final int SIZE_OF_SINGLE = ClassLayout.parseClass(SingleKHyperLogLogState.class).instanceSize();
    private static final int SIZE_OF_GROUPED = ClassLayout.parseClass(GroupedKHyperLogLogState.class).instanceSize();

    public KHyperLogLogState createSingleState() {
        return new SingleKHyperLogLogState();
    }

    public Class<? extends KHyperLogLogState> getSingleStateClass() {
        return SingleKHyperLogLogState.class;
    }

    public KHyperLogLogState createGroupedState() {
        return new GroupedKHyperLogLogState();
    }

    public Class<? extends KHyperLogLogState> getGroupedStateClass() {
        return GroupedKHyperLogLogState.class;
    }

    public static class SingleKHyperLogLogState
    implements KHyperLogLogState {
        private KHyperLogLog khll;

        @Override
        public KHyperLogLog getKHLL() {
            return this.khll;
        }

        @Override
        public void setKHLL(KHyperLogLog value) {
            this.khll = value;
        }

        public long getEstimatedSize() {
            if (this.khll == null) {
                return SIZE_OF_SINGLE;
            }
            return SIZE_OF_SINGLE + this.khll.estimatedInMemorySize();
        }
    }

    public static class GroupedKHyperLogLogState
    implements GroupedAccumulatorState,
    KHyperLogLogState {
        private final ObjectBigArray<KHyperLogLog> khlls = new ObjectBigArray();
        private long groupId;
        private long size;

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public void ensureCapacity(long size) {
            this.khlls.ensureCapacity(size);
        }

        @Override
        public KHyperLogLog getKHLL() {
            return (KHyperLogLog)this.khlls.get(this.groupId);
        }

        @Override
        public void setKHLL(KHyperLogLog value) {
            if (this.getKHLL() != null) {
                this.size -= (long)this.getKHLL().estimatedInMemorySize();
            }
            this.size += (long)value.estimatedInMemorySize();
            this.khlls.set(this.groupId, (Object)value);
        }

        public long getEstimatedSize() {
            return (long)SIZE_OF_GROUPED + this.size + this.khlls.sizeOf();
        }
    }
}

