/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc.optimization;

import com.facebook.presto.spi.relation.ConstantExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class JdbcExpression {
    private final String expression;
    private final List<ConstantExpression> boundConstantValues;

    public JdbcExpression(String expression) {
        this(expression, (List<ConstantExpression>)ImmutableList.of());
    }

    @JsonCreator
    public JdbcExpression(@JsonProperty(value="translatedString") String expression, @JsonProperty(value="boundConstantValues") List<ConstantExpression> constantBindValues) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.boundConstantValues = Objects.requireNonNull(constantBindValues, "boundConstantValues is null");
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty
    public List<ConstantExpression> getBoundConstantValues() {
        return this.boundConstantValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcExpression that = (JdbcExpression)o;
        return this.expression.equals(that.expression) && this.boundConstantValues.equals(that.boundConstantValues);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.boundConstantValues);
    }
}

