/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.discovery.client.DiscoveryBinder;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.discovery.server.DiscoveryConfig;
import com.facebook.airlift.discovery.server.DiscoveryServiceSelector;
import com.facebook.airlift.discovery.server.DynamicAnnouncementResource;
import com.facebook.airlift.discovery.server.DynamicStore;
import com.facebook.airlift.discovery.server.ForDynamicStore;
import com.facebook.airlift.discovery.server.Id;
import com.facebook.airlift.discovery.server.ReplicatedDynamicStore;
import com.facebook.airlift.discovery.server.Service;
import com.facebook.airlift.discovery.server.ServiceResource;
import com.facebook.airlift.discovery.server.StaticStore;
import com.facebook.airlift.discovery.store.InMemoryStore;
import com.facebook.airlift.discovery.store.ReplicatedStoreModule;
import com.facebook.airlift.jaxrs.JaxrsBinder;
import com.facebook.airlift.json.JsonCodecBinder;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Set;

public class EmbeddedDiscoveryModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(DiscoveryConfig.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ServiceResource.class);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("discovery");
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Service.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(Service.class);
        binder.bind(ServiceSelector.class).to(DiscoveryServiceSelector.class);
        binder.bind(StaticStore.class).to(EmptyStaticStore.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(DynamicAnnouncementResource.class);
        binder.bind(DynamicStore.class).to(ReplicatedDynamicStore.class).in(Scopes.SINGLETON);
        binder.install((Module)new ReplicatedStoreModule("dynamic", ForDynamicStore.class, InMemoryStore.class));
    }

    private static class EmptyStaticStore
    implements StaticStore {
        private EmptyStaticStore() {
        }

        @Override
        public void put(Service service) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete(Id<Service> id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Service> getAll() {
            return ImmutableSet.of();
        }

        @Override
        public Set<Service> get(String type) {
            return ImmutableSet.of();
        }

        @Override
        public Set<Service> get(String type, String pool) {
            return ImmutableSet.of();
        }
    }
}

