/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server;

import com.facebook.airlift.discovery.server.Id;
import com.facebook.airlift.discovery.server.Service;
import com.facebook.airlift.discovery.server.Services;
import com.facebook.airlift.discovery.server.StaticAnnouncement;
import com.facebook.airlift.discovery.server.StaticStore;
import com.facebook.airlift.node.NodeInfo;
import com.google.common.base.MoreObjects;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/announcement/static")
public class StaticAnnouncementResource {
    private final StaticStore store;
    private final NodeInfo nodeInfo;

    @Inject
    public StaticAnnouncementResource(StaticStore store, NodeInfo nodeInfo) {
        this.store = store;
        this.nodeInfo = nodeInfo;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response post(StaticAnnouncement announcement, @Context UriInfo uriInfo) {
        if (!this.nodeInfo.getEnvironment().equals(announcement.getEnvironment())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Environment mismatch. Expected: %s, Provided: %s", this.nodeInfo.getEnvironment(), announcement.getEnvironment())).build();
        }
        Id<Service> id = Id.random();
        String location = (String)MoreObjects.firstNonNull((Object)announcement.getLocation(), (Object)("/somewhere/" + id));
        Service service = Service.copyOf(announcement).setId(id).setLocation(location).build();
        this.store.put(service);
        URI uri = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(StaticAnnouncementResource.class).path("{id}").build(new Object[]{id});
        return Response.created((URI)uri).entity((Object)service).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Services get() {
        return new Services(this.nodeInfo.getEnvironment(), this.store.getAll());
    }

    @DELETE
    @Path(value="{id}")
    public void delete(@PathParam(value="id") Id<Service> id) {
        this.store.delete(id);
    }
}

