/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.drift.client.DriftClient;
import com.facebook.drift.client.DriftInvocationHandler;
import com.facebook.drift.client.DriftMethodHandler;
import com.facebook.drift.client.ExceptionClassifier;
import com.facebook.drift.client.FilteredMethodInvoker;
import com.facebook.drift.client.MethodInvocationFilter;
import com.facebook.drift.client.RetryPolicy;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.stats.MethodInvocationStat;
import com.facebook.drift.client.stats.MethodInvocationStatsFactory;
import com.facebook.drift.client.stats.NullMethodInvocationStat;
import com.facebook.drift.client.stats.NullMethodInvocationStatsFactory;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.metadata.ThriftMethodMetadata;
import com.facebook.drift.codec.metadata.ThriftServiceMetadata;
import com.facebook.drift.transport.MethodMetadata;
import com.facebook.drift.transport.client.Address;
import com.facebook.drift.transport.client.DriftClientConfig;
import com.facebook.drift.transport.client.MethodInvoker;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Reflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class DriftClientFactory {
    private final ThriftCodecManager codecManager;
    private final Supplier<MethodInvoker> methodInvokerSupplier;
    private final AddressSelector<? extends Address> addressSelector;
    private final ExceptionClassifier exceptionClassifier;
    private final ConcurrentMap<Class<?>, ThriftServiceMetadata> serviceMetadataCache = new ConcurrentHashMap();
    private final MethodInvocationStatsFactory methodInvocationStatsFactory;

    public DriftClientFactory(ThriftCodecManager codecManager, Supplier<MethodInvoker> methodInvokerSupplier, AddressSelector<? extends Address> addressSelector, ExceptionClassifier exceptionClassifier, MethodInvocationStatsFactory methodInvocationStatsFactory) {
        this.codecManager = Objects.requireNonNull(codecManager, "codecManager is null");
        this.methodInvokerSupplier = Objects.requireNonNull(methodInvokerSupplier, "methodInvokerSupplier is null");
        this.addressSelector = Objects.requireNonNull(addressSelector, "addressSelector is null");
        this.exceptionClassifier = exceptionClassifier;
        this.methodInvocationStatsFactory = Objects.requireNonNull(methodInvocationStatsFactory, "methodInvocationStatsFactory is null");
    }

    public DriftClientFactory(ThriftCodecManager codecManager, MethodInvokerFactory<?> invokerFactory, AddressSelector<? extends Address> addressSelector, ExceptionClassifier exceptionClassifier) {
        this(codecManager, () -> invokerFactory.createMethodInvoker(null), addressSelector, exceptionClassifier, new NullMethodInvocationStatsFactory());
    }

    public DriftClientFactory(ThriftCodecManager codecManager, MethodInvokerFactory<?> invokerFactory, AddressSelector<? extends Address> addressSelector) {
        this(codecManager, invokerFactory, addressSelector, ExceptionClassifier.NORMAL_RESULT);
    }

    public <T> DriftClient<T> createDriftClient(Class<T> clientInterface) {
        return this.createDriftClient(clientInterface, Optional.empty(), (List<MethodInvocationFilter>)ImmutableList.of(), new DriftClientConfig());
    }

    public <T> DriftClient<T> createDriftClient(Class<T> clientInterface, Optional<Class<? extends Annotation>> qualifierAnnotation, List<MethodInvocationFilter> filters, DriftClientConfig config) {
        ThriftServiceMetadata serviceMetadata = this.serviceMetadataCache.computeIfAbsent(clientInterface, clazz -> new ThriftServiceMetadata(clazz, this.codecManager.getCatalog()));
        MethodInvoker invoker = FilteredMethodInvoker.createFilteredMethodInvoker(filters, this.methodInvokerSupplier.get());
        Optional<String> qualifier = qualifierAnnotation.map(Class::getSimpleName);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ThriftMethodMetadata method : serviceMetadata.getMethods()) {
            MethodMetadata metadata = MethodMetadata.toMethodMetadata((ThriftCodecManager)this.codecManager, (ThriftMethodMetadata)method);
            RetryPolicy retryPolicy = new RetryPolicy(config, this.exceptionClassifier);
            MethodInvocationStat statHandler = config.isStatsEnabled() ? this.methodInvocationStatsFactory.getStat(serviceMetadata, qualifier, metadata) : new NullMethodInvocationStat();
            DriftMethodHandler handler = new DriftMethodHandler(metadata, method.getHeaderParameters(), invoker, method.isAsync(), this.addressSelector, retryPolicy, statHandler);
            builder.put((Object)method.getMethod(), (Object)handler);
        }
        ImmutableMap methods = builder.build();
        return (arg_0, arg_1) -> DriftClientFactory.lambda$createDriftClient$2(clientInterface, serviceMetadata, (Map)methods, arg_0, arg_1);
    }

    private static /* synthetic */ Object lambda$createDriftClient$2(Class clientInterface, ThriftServiceMetadata serviceMetadata, Map methods, Optional context, Map headers) {
        return Reflection.newProxy((Class)clientInterface, (InvocationHandler)new DriftInvocationHandler(serviceMetadata.getName(), methods, context, headers));
    }
}

