/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.http.server.AuthorizationResult;
import com.facebook.airlift.http.server.Authorizer;
import com.facebook.airlift.http.server.HttpServerConfig;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthorizationEnabledServlet
extends HttpServlet {
    private final Servlet delegate;
    private final Authorizer authorizer;
    private final HttpServerConfig.AuthorizationPolicy authorizationPolicy;
    private final Set<String> defaultAllowedRoles;
    private final Optional<Set<String>> allowedRoles;
    private final boolean allowUnsecureRequestsInAuthorizer;

    public AuthorizationEnabledServlet(Servlet delegate, Authorizer authorizer, HttpServerConfig.AuthorizationPolicy authorizationPolicy, Set<String> defaultAllowedRoles, boolean allowUnsecureRequestsInAuthorizer) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer is null");
        this.authorizationPolicy = Objects.requireNonNull(authorizationPolicy, "authorizationPolicy is null");
        this.defaultAllowedRoles = Objects.requireNonNull(defaultAllowedRoles, "defaultAllowedRoles is null");
        this.allowedRoles = AuthorizationEnabledServlet.getRolesFromClassMetadata(delegate);
        this.allowUnsecureRequestsInAuthorizer = allowUnsecureRequestsInAuthorizer;
    }

    public void init() throws ServletException {
        super.init();
        this.delegate.init(this.getServletConfig());
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        AuthorizationResult result;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!request.isSecure() && this.allowUnsecureRequestsInAuthorizer) {
            return;
        }
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            AuthorizationEnabledServlet.abortWithMessage(request, response, "Request principal is missing.");
            return;
        }
        Optional<Set<String>> allowedRoles = this.allowedRoles;
        if (!allowedRoles.isPresent()) {
            switch (this.authorizationPolicy) {
                case ALLOW: {
                    this.delegate.service(req, res);
                    return;
                }
                case DENY: {
                    AuthorizationEnabledServlet.abortWithMessage(request, response, String.format("Principal %s is not allowed to access the resource. Reason: denied by default policy", principal.getName()));
                    return;
                }
                case DEFAULT_ROLES: {
                    allowedRoles = Optional.of(this.defaultAllowedRoles);
                    break;
                }
            }
        }
        if (!(result = this.authorizer.authorize(principal, allowedRoles.get(), request.getRequestURL().toString())).isAllowed()) {
            AuthorizationEnabledServlet.abortWithMessage(request, response, String.format("Principal %s is not allowed to access the resource. Reason: %s", principal.getName(), result.getReason()));
            return;
        }
        this.delegate.service(req, res);
    }

    private static void abortWithMessage(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        AuthorizationEnabledServlet.skipRequestBody(request);
        response.sendError(403, String.format(message, new Object[0]));
    }

    private static void skipRequestBody(HttpServletRequest request) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)ByteStreams.nullOutputStream());
        }
    }

    private static Optional<Set<String>> getRolesFromClassMetadata(Servlet servlet) {
        if (servlet.getClass().isAnnotationPresent(RolesAllowed.class)) {
            return Optional.of(ImmutableSet.copyOf((Object[])servlet.getClass().getAnnotation(RolesAllowed.class).value()));
        }
        return Optional.empty();
    }
}

