/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.http.server.AuthorizationResult;
import com.facebook.airlift.http.server.Authorizer;
import com.facebook.airlift.http.server.ConfigurationBasedAuthorizerConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class ConfigurationBasedAuthorizer
implements Authorizer {
    private final Map<String, Pattern> roleRegexMap;

    @Inject
    public ConfigurationBasedAuthorizer(ConfigurationBasedAuthorizerConfig config) throws IOException {
        this(config.getRoleMapFilePath());
    }

    @VisibleForTesting
    public ConfigurationBasedAuthorizer(String roleMapFilePath) throws IOException {
        Objects.requireNonNull(roleMapFilePath, "roleMapFilePath is null");
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(roleMapFilePath);){
            properties.load(inputStream);
        }
        this.roleRegexMap = (Map)Maps.fromProperties((Properties)properties).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> Pattern.compile((String)e.getValue())));
    }

    @Override
    public AuthorizationResult authorize(Principal principal, Set<String> allowedRoles, String requestUrl) {
        for (String role : allowedRoles) {
            if (!this.roleRegexMap.containsKey(role) || !this.isPrincipalAuthorized(principal, this.roleRegexMap.get(role))) continue;
            return AuthorizationResult.success();
        }
        return AuthorizationResult.failure(String.format("%s is not a member of the allowed roles: %s", principal.getName(), allowedRoles));
    }

    private boolean isPrincipalAuthorized(Principal principal, Pattern identityRegex) {
        return identityRegex.matcher(principal.getName()).matches();
    }
}

