/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server.testing;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.discovery.client.AnnouncementHttpServerInfo;
import com.facebook.airlift.http.server.AuthenticationFilter;
import com.facebook.airlift.http.server.Authenticator;
import com.facebook.airlift.http.server.Authorizer;
import com.facebook.airlift.http.server.HttpServer;
import com.facebook.airlift.http.server.HttpServerBinder;
import com.facebook.airlift.http.server.HttpServerConfig;
import com.facebook.airlift.http.server.HttpServerInfo;
import com.facebook.airlift.http.server.LocalAnnouncementHttpServerInfo;
import com.facebook.airlift.http.server.TheServlet;
import com.facebook.airlift.http.server.testing.TestingHttpServer;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;

public class TestingHttpServerModule
implements Module {
    private final int httpPort;

    public TestingHttpServerModule() {
        this(0);
    }

    public TestingHttpServerModule(int httpPort) {
        this.httpPort = httpPort;
    }

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        ConfigBinder.configBinder((Binder)binder).bindConfig(HttpServerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpServerConfig.class, config -> {
            config.setHttpPort(this.httpPort);
            if (this.httpPort == 0) {
                config.setHttpsPort(0);
            }
        });
        binder.bind(HttpServerInfo.class).in(Scopes.SINGLETON);
        binder.bind(TestingHttpServer.class).in(Scopes.SINGLETON);
        binder.bind(HttpServer.class).to(Key.get(TestingHttpServer.class));
        MapBinder.newMapBinder((Binder)binder, String.class, Servlet.class, TheServlet.class);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class);
        Multibinder.newSetBinder((Binder)binder, HttpServerBinder.HttpResourceBinding.class, TheServlet.class);
        binder.bind(AnnouncementHttpServerInfo.class).to(LocalAnnouncementHttpServerInfo.class);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().to(AuthenticationFilter.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Authenticator.class);
        OptionalBinder.newOptionalBinder((Binder)binder, Authorizer.class);
    }

    @Provides
    List<Authenticator> getAuthenticatorList(Set<Authenticator> authenticators) {
        return ImmutableList.copyOf(authenticators);
    }
}

