/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.LongEnumType;
import com.facebook.presto.common.type.ParameterKind;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeParameter;
import java.util.List;

public final class LongEnumParametricType
implements ParametricType {
    private final String name;
    private final LongEnumType.LongEnumMap enumMap;

    public LongEnumParametricType(String name, LongEnumType.LongEnumMap enumMap) {
        this.name = name;
        this.enumMap = enumMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type createType(List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return new LongEnumType(this.name, this.enumMap);
        }
        LongEnumParametricType.checkArgument(parameters.size() == 1, "Enum type expects exactly one parameter, got %s", parameters);
        LongEnumParametricType.checkArgument(parameters.get(0).getKind() == ParameterKind.LONG_ENUM, "Enum definition expected, got %s", parameters);
        return new LongEnumType(this.name, parameters.get(0).getLongEnumMap());
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }
}

