/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.AbstractLongType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.EnumType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.TypeUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class LongEnumType
extends AbstractLongType
implements EnumType<Long> {
    private final LongEnumMap enumMap;

    public LongEnumType(String name, LongEnumMap enumMap) {
        super(new TypeSignature(name, TypeSignatureParameter.of(enumMap)));
        this.enumMap = enumMap;
    }

    @Override
    public Map<String, Long> getEnumMap() {
        return this.enumMap.getEnumMap();
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getLong(position);
    }

    @Override
    public Type getValueType() {
        return BigintType.BIGINT;
    }

    @Override
    public String getDisplayName() {
        return this.getTypeSignature().getBase();
    }

    public static class LongEnumMap {
        private final Map<String, Long> enumMap;

        @JsonCreator
        public LongEnumMap(@JsonProperty(value="enumMap") Map<String, Long> enumMap) {
            TypeUtils.validateEnumMap(enumMap);
            this.enumMap = TypeUtils.normalizeEnumMap(enumMap);
        }

        @JsonProperty
        public Map<String, Long> getEnumMap() {
            return this.enumMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongEnumMap other = (LongEnumMap)o;
            return Objects.equals(this.enumMap, other.enumMap);
        }

        public String toString() {
            return "enum:bigint{" + this.enumMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> String.format("\"%s\": %d", ((String)e.getKey()).replaceAll("\"", "\"\""), e.getValue())).collect(Collectors.joining(", ")) + "}";
        }

        public int hashCode() {
            return Objects.hash(this.enumMap);
        }
    }
}

