/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs.thrift;

import com.facebook.airlift.http.client.thrift.ThriftProtocolException;
import com.facebook.airlift.http.client.thrift.ThriftProtocolUtils;
import com.facebook.airlift.http.client.thrift.ThriftRequestUtils;
import com.facebook.airlift.jaxrs.BaseMapper;
import com.facebook.airlift.jaxrs.thrift.ThriftMapperParsingException;
import com.facebook.airlift.log.Logger;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.protocol.TTransportException;
import com.facebook.drift.transport.netty.codec.Protocol;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
@Produces(value={"application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
public class ThriftMapper
extends BaseMapper {
    public static final Logger log = Logger.get(ThriftMapper.class);
    private final ThriftCodecManager thriftCodecManager;

    @Inject
    public ThriftMapper(ThriftCodecManager thriftCodecManager) {
        this.thriftCodecManager = Objects.requireNonNull(thriftCodecManager, "thriftCodecManager is null");
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        try {
            ThriftCodec codec = this.thriftCodecManager.getCodec(genericType);
            Object value = ThriftProtocolUtils.read((ThriftCodec)codec, (Protocol)this.getThriftProtocol(mediaType, codec), (InputStream)inputStream);
            return value;
        }
        catch (Exception e) {
            if (e instanceof IOException && !(e instanceof ThriftProtocolException) && !(e instanceof EOFException)) {
                throw (IOException)e;
            }
            if (e instanceof TTransportException && e.getCause() instanceof IOException && !(e.getCause() instanceof EOFException)) {
                throw (IOException)e.getCause();
            }
            log.debug((Throwable)e, "Invalid Thrift input for Java type %s", new Object[]{genericType});
            throw new ThriftMapperParsingException(type, (Throwable)e);
        }
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        try {
            ThriftCodec codec = this.thriftCodecManager.getCodec(type);
            ThriftProtocolUtils.write((Object)value, (ThriftCodec)codec, (Protocol)this.getThriftProtocol(mediaType, codec), (OutputStream)outputStream);
        }
        catch (Exception e) {
            if (e instanceof EOFException || e instanceof TTransportException && e.getCause() instanceof EOFException) {
                return;
            }
            log.debug((Throwable)e, "Can not serialize to thrift for Java type %s", new Object[]{type});
            if (e instanceof ThriftProtocolException) {
                throw e;
            }
            throw new ThriftMapperParsingException(type, (Throwable)e);
        }
    }

    private Protocol getThriftProtocol(MediaType mediaType, ThriftCodec<?> thriftCodec) {
        String mimeType = mediaType.toString();
        if (!ThriftRequestUtils.validThriftMimeTypes.contains(mimeType)) {
            throw new IllegalArgumentException("Invalid response. No protocol type specified. Unable to create " + thriftCodec.getType() + " from THRIFT response");
        }
        String encodingType = mimeType.substring("application/x-thrift+".length());
        return Protocol.valueOf((String)encodingType.toUpperCase());
    }
}

