/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.execution.warnings.WarningHandlingLevel;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class SystemSessionProperties {
    public static final String OPTIMIZE_HASH_GENERATION = "optimize_hash_generation";
    public static final String JOIN_DISTRIBUTION_TYPE = "join_distribution_type";
    public static final String JOIN_MAX_BROADCAST_TABLE_SIZE = "join_max_broadcast_table_size";
    public static final String DISTRIBUTED_JOIN = "distributed_join";
    public static final String DISTRIBUTED_INDEX_JOIN = "distributed_index_join";
    public static final String HASH_PARTITION_COUNT = "hash_partition_count";
    public static final String PARTITIONING_PROVIDER_CATALOG = "partitioning_provider_catalog";
    public static final String EXCHANGE_MATERIALIZATION_STRATEGY = "exchange_materialization_strategy";
    public static final String USE_STREAMING_EXCHANGE_FOR_MARK_DISTINCT = "use_stream_exchange_for_mark_distinct";
    public static final String GROUPED_EXECUTION = "grouped_execution";
    public static final String RECOVERABLE_GROUPED_EXECUTION = "recoverable_grouped_execution";
    public static final String MAX_FAILED_TASK_PERCENTAGE = "max_failed_task_percentage";
    public static final String MAX_STAGE_RETRIES = "max_stage_retries";
    public static final String PREFER_STREAMING_OPERATORS = "prefer_streaming_operators";
    public static final String TASK_WRITER_COUNT = "task_writer_count";
    public static final String TASK_PARTITIONED_WRITER_COUNT = "task_partitioned_writer_count";
    public static final String TASK_CONCURRENCY = "task_concurrency";
    public static final String TASK_SHARE_INDEX_LOADING = "task_share_index_loading";
    public static final String QUERY_MAX_MEMORY = "query_max_memory";
    public static final String QUERY_MAX_MEMORY_PER_NODE = "query_max_memory_per_node";
    public static final String QUERY_MAX_BROADCAST_MEMORY = "query_max_broadcast_memory";
    public static final String QUERY_MAX_TOTAL_MEMORY = "query_max_total_memory";
    public static final String QUERY_MAX_TOTAL_MEMORY_PER_NODE = "query_max_total_memory_per_node";
    public static final String QUERY_MAX_EXECUTION_TIME = "query_max_execution_time";
    public static final String QUERY_MAX_RUN_TIME = "query_max_run_time";
    public static final String RESOURCE_OVERCOMMIT = "resource_overcommit";
    public static final String QUERY_MAX_CPU_TIME = "query_max_cpu_time";
    public static final String QUERY_MAX_SCAN_RAW_INPUT_BYTES = "query_max_scan_raw_input_bytes";
    public static final String QUERY_MAX_OUTPUT_SIZE = "query_max_output_size";
    public static final String QUERY_MAX_STAGE_COUNT = "query_max_stage_count";
    public static final String REDISTRIBUTE_WRITES = "redistribute_writes";
    public static final String SCALE_WRITERS = "scale_writers";
    public static final String WRITER_MIN_SIZE = "writer_min_size";
    public static final String OPTIMIZED_SCALE_WRITER_PRODUCER_BUFFER = "optimized_scale_writer_producer_buffer";
    public static final String PUSH_TABLE_WRITE_THROUGH_UNION = "push_table_write_through_union";
    public static final String EXECUTION_POLICY = "execution_policy";
    public static final String DICTIONARY_AGGREGATION = "dictionary_aggregation";
    public static final String PLAN_WITH_TABLE_NODE_PARTITIONING = "plan_with_table_node_partitioning";
    public static final String SPATIAL_JOIN = "spatial_join";
    public static final String SPATIAL_PARTITIONING_TABLE_NAME = "spatial_partitioning_table_name";
    public static final String COLOCATED_JOIN = "colocated_join";
    public static final String CONCURRENT_LIFESPANS_PER_NODE = "concurrent_lifespans_per_task";
    public static final String REORDER_JOINS = "reorder_joins";
    public static final String JOIN_REORDERING_STRATEGY = "join_reordering_strategy";
    public static final String PARTIAL_MERGE_PUSHDOWN_STRATEGY = "partial_merge_pushdown_strategy";
    public static final String MAX_REORDERED_JOINS = "max_reordered_joins";
    public static final String INITIAL_SPLITS_PER_NODE = "initial_splits_per_node";
    public static final String SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL = "split_concurrency_adjustment_interval";
    public static final String OPTIMIZE_METADATA_QUERIES = "optimize_metadata_queries";
    public static final String FAST_INEQUALITY_JOINS = "fast_inequality_joins";
    public static final String QUERY_PRIORITY = "query_priority";
    public static final String SPILL_ENABLED = "spill_enabled";
    public static final String JOIN_SPILL_ENABLED = "join_spill_enabled";
    public static final String AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT = "aggregation_operator_unspill_memory_limit";
    public static final String OPTIMIZE_DISTINCT_AGGREGATIONS = "optimize_mixed_distinct_aggregations";
    public static final String LEGACY_ROW_FIELD_ORDINAL_ACCESS = "legacy_row_field_ordinal_access";
    public static final String LEGACY_MAP_SUBSCRIPT = "do_not_use_legacy_map_subscript";
    public static final String ITERATIVE_OPTIMIZER = "iterative_optimizer_enabled";
    public static final String ITERATIVE_OPTIMIZER_TIMEOUT = "iterative_optimizer_timeout";
    public static final String RUNTIME_OPTIMIZER_ENABLED = "runtime_optimizer_enabled";
    public static final String EXCHANGE_COMPRESSION = "exchange_compression";
    public static final String LEGACY_TIMESTAMP = "legacy_timestamp";
    public static final String ENABLE_INTERMEDIATE_AGGREGATIONS = "enable_intermediate_aggregations";
    public static final String PUSH_AGGREGATION_THROUGH_JOIN = "push_aggregation_through_join";
    public static final String PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN = "push_partial_aggregation_through_join";
    public static final String PARSE_DECIMAL_LITERALS_AS_DOUBLE = "parse_decimal_literals_as_double";
    public static final String FORCE_SINGLE_NODE_OUTPUT = "force_single_node_output";
    public static final String FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE = "filter_and_project_min_output_page_size";
    public static final String FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT = "filter_and_project_min_output_page_row_count";
    public static final String DISTRIBUTED_SORT = "distributed_sort";
    public static final String USE_MARK_DISTINCT = "use_mark_distinct";
    public static final String PREFER_PARTIAL_AGGREGATION = "prefer_partial_aggregation";
    public static final String OPTIMIZE_TOP_N_ROW_NUMBER = "optimize_top_n_row_number";
    public static final String MAX_GROUPING_SETS = "max_grouping_sets";
    public static final String LEGACY_UNNEST = "legacy_unnest";
    public static final String STATISTICS_CPU_TIMER_ENABLED = "statistics_cpu_timer_enabled";
    public static final String ENABLE_STATS_CALCULATOR = "enable_stats_calculator";
    public static final String ENABLE_STATS_COLLECTION_FOR_TEMPORARY_TABLE = "enable_stats_collection_for_temporary_table";
    public static final String IGNORE_STATS_CALCULATOR_FAILURES = "ignore_stats_calculator_failures";
    public static final String PRINT_STATS_FOR_NON_JOIN_QUERY = "print_stats_for_non_join_query";
    public static final String MAX_DRIVERS_PER_TASK = "max_drivers_per_task";
    public static final String MAX_TASKS_PER_STAGE = "max_tasks_per_stage";
    public static final String DEFAULT_FILTER_FACTOR_ENABLED = "default_filter_factor_enabled";
    public static final String PUSH_LIMIT_THROUGH_OUTER_JOIN = "push_limit_through_outer_join";
    public static final String MAX_CONCURRENT_MATERIALIZATIONS = "max_concurrent_materializations";
    public static final String PUSHDOWN_SUBFIELDS_ENABLED = "pushdown_subfields_enabled";
    public static final String TABLE_WRITER_MERGE_OPERATOR_ENABLED = "table_writer_merge_operator_enabled";
    public static final String INDEX_LOADER_TIMEOUT = "index_loader_timeout";
    public static final String OPTIMIZED_REPARTITIONING_ENABLED = "optimized_repartitioning";
    public static final String AGGREGATION_PARTITIONING_MERGING_STRATEGY = "aggregation_partitioning_merging_strategy";
    public static final String LIST_BUILT_IN_FUNCTIONS_ONLY = "list_built_in_functions_only";
    public static final String PARTITIONING_PRECISION_STRATEGY = "partitioning_precision_strategy";
    public static final String EXPERIMENTAL_FUNCTIONS_ENABLED = "experimental_functions_enabled";
    public static final String USE_LEGACY_SCHEDULER = "use_legacy_scheduler";
    public static final String OPTIMIZE_COMMON_SUB_EXPRESSIONS = "optimize_common_sub_expressions";
    public static final String PREFER_DISTRIBUTED_UNION = "prefer_distributed_union";
    public static final String WARNING_HANDLING = "warning_handling";
    public static final String OPTIMIZE_NULLS_IN_JOINS = "optimize_nulls_in_join";
    public static final String TARGET_RESULT_SIZE = "target_result_size";
    public static final String PUSHDOWN_DEREFERENCE_ENABLED = "pushdown_dereference_enabled";
    public static final String ENABLE_DYNAMIC_FILTERING = "enable_dynamic_filtering";
    public static final String DYNAMIC_FILTERING_MAX_PER_DRIVER_ROW_COUNT = "dynamic_filtering_max_per_driver_row_count";
    public static final String DYNAMIC_FILTERING_MAX_PER_DRIVER_SIZE = "dynamic_filtering_max_per_driver_size";
    public static final String FRAGMENT_RESULT_CACHING_ENABLED = "fragment_result_caching_enabled";
    public static final String LEGACY_TYPE_COERCION_WARNING_ENABLED = "legacy_type_coercion_warning_enabled";
    public static final String INLINE_SQL_FUNCTIONS = "inline_sql_functions";
    public static final String REMOTE_FUNCTIONS_ENABLED = "remote_functions_enabled";
    public static final String CHECK_ACCESS_CONTROL_ON_UTILIZED_COLUMNS_ONLY = "check_access_control_on_utilized_columns_only";
    private final List<PropertyMetadata<?>> sessionProperties;

    public SystemSessionProperties() {
        this(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig(), new NodeMemoryConfig(), new WarningCollectorConfig());
    }

    @Inject
    public SystemSessionProperties(QueryManagerConfig queryManagerConfig, TaskManagerConfig taskManagerConfig, MemoryManagerConfig memoryManagerConfig, FeaturesConfig featuresConfig, NodeMemoryConfig nodeMemoryConfig, WarningCollectorConfig warningCollectorConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)EXECUTION_POLICY, (String)"Policy used for scheduling query tasks", (String)queryManagerConfig.getQueryExecutionPolicy(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)OPTIMIZE_HASH_GENERATION, (String)"Compute hash codes for distribution, joins, and aggregations early in query plan", (Boolean)featuresConfig.isOptimizeHashGeneration(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)DISTRIBUTED_JOIN, (String)"(DEPRECATED) Use a distributed join instead of a broadcast join. If this is set, join_distribution_type is ignored.", null, (boolean)false), (Object)new PropertyMetadata(JOIN_DISTRIBUTION_TYPE, String.format("The join method to use. Options are %s", Stream.of(FeaturesConfig.JoinDistributionType.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.JoinDistributionType.class, (Object)featuresConfig.getJoinDistributionType(), false, value -> FeaturesConfig.JoinDistributionType.valueOf(((String)value).toUpperCase()), Enum::name), (Object)new PropertyMetadata(JOIN_MAX_BROADCAST_TABLE_SIZE, "Maximum estimated size of a table that can be broadcast for JOIN.", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getJoinMaxBroadcastTableSize(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), (Object)PropertyMetadata.booleanProperty((String)DISTRIBUTED_INDEX_JOIN, (String)"Distribute index joins on join keys instead of executing inline", (Boolean)featuresConfig.isDistributedIndexJoinsEnabled(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)HASH_PARTITION_COUNT, (String)"Number of partitions for distributed joins and aggregations", (Integer)queryManagerConfig.getHashPartitionCount(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)PARTITIONING_PROVIDER_CATALOG, (String)"Name of the catalog providing custom partitioning", (String)queryManagerConfig.getPartitioningProviderCatalog(), (boolean)false), (Object)new PropertyMetadata(EXCHANGE_MATERIALIZATION_STRATEGY, String.format("The exchange materialization strategy to use. Options are %s", Stream.of(QueryManagerConfig.ExchangeMaterializationStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, QueryManagerConfig.ExchangeMaterializationStrategy.class, (Object)queryManagerConfig.getExchangeMaterializationStrategy(), false, value -> QueryManagerConfig.ExchangeMaterializationStrategy.valueOf(((String)value).toUpperCase()), Enum::name), (Object)PropertyMetadata.booleanProperty((String)USE_STREAMING_EXCHANGE_FOR_MARK_DISTINCT, (String)"Use streaming instead of materialization for mark distinct with materialized exchange enabled", (Boolean)queryManagerConfig.getUseStreamingExchangeForMarkDistinct(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)GROUPED_EXECUTION, (String)"Use grouped execution when possible", (Boolean)featuresConfig.isGroupedExecutionEnabled(), (boolean)false), (Object)PropertyMetadata.doubleProperty((String)MAX_FAILED_TASK_PERCENTAGE, (String)"Max percentage of failed tasks that are retryable for recoverable dynamic scheduling", (Double)featuresConfig.getMaxFailedTaskPercentage(), (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.booleanProperty((String)RECOVERABLE_GROUPED_EXECUTION, (String)"Experimental: Use recoverable grouped execution when possible", (Boolean)featuresConfig.isRecoverableGroupedExecutionEnabled(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_STAGE_RETRIES, (String)"Maximum number of times that stages can be retried", (Integer)featuresConfig.getMaxStageRetries(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFER_STREAMING_OPERATORS, (String)"Prefer source table layouts that produce streaming operators", (Boolean)false, (boolean)false), new PropertyMetadata(TASK_WRITER_COUNT, "Default number of local parallel table writer jobs per worker", (Type)BigintType.BIGINT, Integer.class, (Object)taskManagerConfig.getWriterCount(), false, value -> SystemSessionProperties.validateValueIsPowerOfTwo(Objects.requireNonNull(value, "value is null"), TASK_WRITER_COUNT), value -> value), new PropertyMetadata(TASK_PARTITIONED_WRITER_COUNT, "Number of writers per task for partitioned writes. If not set, the number set by task.writer-count will be used", (Type)BigintType.BIGINT, Integer.class, (Object)taskManagerConfig.getPartitionedWriterCount(), false, value -> SystemSessionProperties.validateValueIsPowerOfTwo(value, TASK_PARTITIONED_WRITER_COUNT), value -> value), PropertyMetadata.booleanProperty((String)REDISTRIBUTE_WRITES, (String)"Force parallel distributed writes", (Boolean)featuresConfig.isRedistributeWrites(), (boolean)false), PropertyMetadata.booleanProperty((String)SCALE_WRITERS, (String)"Scale out writers based on throughput (use minimum necessary)", (Boolean)featuresConfig.isScaleWriters(), (boolean)false), new PropertyMetadata(WRITER_MIN_SIZE, "Target minimum size of writer output when scaling writers", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getWriterMinSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)OPTIMIZED_SCALE_WRITER_PRODUCER_BUFFER, (String)"Optimize scale writer creation based on producer buffer", (Boolean)featuresConfig.isOptimizedScaleWriterProducerBuffer(), (boolean)true), PropertyMetadata.booleanProperty((String)PUSH_TABLE_WRITE_THROUGH_UNION, (String)"Parallelize writes when using UNION ALL in queries that write data", (Boolean)featuresConfig.isPushTableWriteThroughUnion(), (boolean)false), new PropertyMetadata(TASK_CONCURRENCY, "Default number of local parallel jobs per worker", (Type)BigintType.BIGINT, Integer.class, (Object)taskManagerConfig.getTaskConcurrency(), false, value -> SystemSessionProperties.validateValueIsPowerOfTwo(Objects.requireNonNull(value, "value is null"), TASK_CONCURRENCY), value -> value), PropertyMetadata.booleanProperty((String)TASK_SHARE_INDEX_LOADING, (String)"Share index join lookups and caching within a task", (Boolean)taskManagerConfig.isShareIndexLoading(), (boolean)false), new PropertyMetadata(QUERY_MAX_RUN_TIME, "Maximum run time of a query (includes the queueing time)", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxRunTime(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_MAX_EXECUTION_TIME, "Maximum execution time of a query", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxExecutionTime(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_MAX_CPU_TIME, "Maximum CPU time of a query", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxCpuTime(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), new PropertyMetadata(QUERY_MAX_MEMORY, "Maximum amount of distributed memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)memoryManagerConfig.getSoftMaxQueryMemory(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_MEMORY_PER_NODE, "Maximum amount of user task memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)nodeMemoryConfig.getSoftMaxQueryMemoryPerNode(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_BROADCAST_MEMORY, "Maximum amount of memory a query can use for broadcast join", (Type)VarcharType.VARCHAR, DataSize.class, (Object)nodeMemoryConfig.getMaxQueryBroadcastMemory(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_TOTAL_MEMORY, "Maximum amount of distributed total memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)memoryManagerConfig.getSoftMaxQueryTotalMemory(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), new PropertyMetadata(QUERY_MAX_TOTAL_MEMORY_PER_NODE, "Maximum amount of total (user + system) task memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)nodeMemoryConfig.getSoftMaxQueryTotalMemoryPerNode(), true, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)RESOURCE_OVERCOMMIT, (String)"Use resources which are not guaranteed to be available to the query", (Boolean)false, (boolean)false), PropertyMetadata.dataSizeProperty((String)QUERY_MAX_SCAN_RAW_INPUT_BYTES, (String)"Maximum scan raw input bytes of a query", (DataSize)queryManagerConfig.getQueryMaxScanRawInputBytes(), (boolean)false), PropertyMetadata.dataSizeProperty((String)QUERY_MAX_OUTPUT_SIZE, (String)"Maximum data that can be fetched by a query", (DataSize)queryManagerConfig.getQueryMaxOutputSize(), (boolean)false), PropertyMetadata.integerProperty((String)QUERY_MAX_STAGE_COUNT, (String)"Temporary: Maximum number of stages a query can have", (Integer)queryManagerConfig.getMaxStageCount(), (boolean)true), PropertyMetadata.booleanProperty((String)DICTIONARY_AGGREGATION, (String)"Enable optimization for aggregations on dictionaries", (Boolean)featuresConfig.isDictionaryAggregation(), (boolean)false), PropertyMetadata.integerProperty((String)INITIAL_SPLITS_PER_NODE, (String)"The number of splits each node will run per task, initially", (Integer)taskManagerConfig.getInitialSplitsPerNode(), (boolean)false), new PropertyMetadata(SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, "Experimental: Interval between changes to the number of concurrent splits per node", (Type)VarcharType.VARCHAR, Duration.class, (Object)taskManagerConfig.getSplitConcurrencyAdjustmentInterval(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)OPTIMIZE_METADATA_QUERIES, (String)"Enable optimization for metadata queries. Note if metadata entry has empty data, the result might be different (e.g. empty Hive partition)", (Boolean)featuresConfig.isOptimizeMetadataQueries(), (boolean)false), PropertyMetadata.integerProperty((String)QUERY_PRIORITY, (String)"The priority of queries. Larger numbers are higher priority", (Integer)1, (boolean)false), PropertyMetadata.booleanProperty((String)PLAN_WITH_TABLE_NODE_PARTITIONING, (String)"Experimental: Adapt plan to pre-partitioned tables", (Boolean)true, (boolean)false), PropertyMetadata.booleanProperty((String)REORDER_JOINS, (String)"(DEPRECATED) Reorder joins to remove unnecessary cross joins. If this is set, join_reordering_strategy will be ignored", null, (boolean)false), new PropertyMetadata(JOIN_REORDERING_STRATEGY, String.format("The join reordering strategy to use. Options are %s", Stream.of(FeaturesConfig.JoinReorderingStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.JoinReorderingStrategy.class, (Object)featuresConfig.getJoinReorderingStrategy(), false, value -> FeaturesConfig.JoinReorderingStrategy.valueOf(((String)value).toUpperCase()), Enum::name), new PropertyMetadata(PARTIAL_MERGE_PUSHDOWN_STRATEGY, String.format("Experimental: Partial merge pushdown strategy to use. Optionas are %s", Stream.of(FeaturesConfig.PartialMergePushdownStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.PartialMergePushdownStrategy.class, (Object)featuresConfig.getPartialMergePushdownStrategy(), false, value -> FeaturesConfig.PartialMergePushdownStrategy.valueOf(((String)value).toUpperCase()), Enum::name), new PropertyMetadata(MAX_REORDERED_JOINS, "The maximum number of joins to reorder as one group in cost-based join reordering", (Type)BigintType.BIGINT, Integer.class, (Object)featuresConfig.getMaxReorderedJoins(), false, value -> {
            int intValue = ((Number)Objects.requireNonNull(value, "value is null")).intValue();
            if (intValue < 2) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than or equal to 2: %s", MAX_REORDERED_JOINS, intValue));
            }
            return intValue;
        }, value -> value), PropertyMetadata.booleanProperty((String)FAST_INEQUALITY_JOINS, (String)"Use faster handling of inequality join if it is possible", (Boolean)featuresConfig.isFastInequalityJoins(), (boolean)false), PropertyMetadata.booleanProperty((String)COLOCATED_JOIN, (String)"Experimental: Use a colocated join when possible", (Boolean)featuresConfig.isColocatedJoinsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SPATIAL_JOIN, (String)"Use spatial index for spatial join when possible", (Boolean)featuresConfig.isSpatialJoinsEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)SPATIAL_PARTITIONING_TABLE_NAME, (String)"Name of the table containing spatial partitioning scheme", null, (boolean)false), PropertyMetadata.integerProperty((String)CONCURRENT_LIFESPANS_PER_NODE, (String)"Experimental: Run a fixed number of groups concurrently for eligible JOINs", (Integer)featuresConfig.getConcurrentLifespansPerTask(), (boolean)false), new PropertyMetadata(SPILL_ENABLED, "Experimental: Enable spilling", (Type)BooleanType.BOOLEAN, Boolean.class, (Object)featuresConfig.isSpillEnabled(), false, value -> {
            boolean spillEnabled = (Boolean)value;
            if (spillEnabled && featuresConfig.getSpillerSpillPaths().isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s cannot be set to true; no spill paths configured", SPILL_ENABLED));
            }
            return spillEnabled;
        }, value -> value), new PropertyMetadata(JOIN_SPILL_ENABLED, "Experimental: Enable join spilling", (Type)BooleanType.BOOLEAN, Boolean.class, (Object)featuresConfig.isJoinSpillingEnabled(), false, value -> {
            boolean joinSpillEnabled = (Boolean)value;
            if (joinSpillEnabled && !featuresConfig.isSpillEnabled()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s cannot be set to true; spilling is not configured", JOIN_SPILL_ENABLED));
            }
            return joinSpillEnabled;
        }, value -> value), new PropertyMetadata(AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, "Experimental: How much memory can should be allocated per aggragation operator in unspilling process", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getAggregationOperatorUnspillMemoryLimit(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)OPTIMIZE_DISTINCT_AGGREGATIONS, (String)"Optimize mixed non-distinct and distinct aggregations", (Boolean)featuresConfig.isOptimizeMixedDistinctAggregations(), (boolean)false), PropertyMetadata.booleanProperty((String)LEGACY_ROW_FIELD_ORDINAL_ACCESS, (String)"Allow accessing anonymous row field with .field0, .field1, ...", (Boolean)featuresConfig.isLegacyRowFieldOrdinalAccess(), (boolean)false), PropertyMetadata.booleanProperty((String)LEGACY_MAP_SUBSCRIPT, (String)"Do not fail the query if map key is missing", (Boolean)featuresConfig.isLegacyMapSubscript(), (boolean)true), PropertyMetadata.booleanProperty((String)ITERATIVE_OPTIMIZER, (String)"Experimental: enable iterative optimizer", (Boolean)featuresConfig.isIterativeOptimizerEnabled(), (boolean)false), new PropertyMetadata(ITERATIVE_OPTIMIZER_TIMEOUT, "Timeout for plan optimization in iterative optimizer", (Type)VarcharType.VARCHAR, Duration.class, (Object)featuresConfig.getIterativeOptimizerTimeout(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)RUNTIME_OPTIMIZER_ENABLED, (String)"Experimental: enable runtime optimizer", (Boolean)featuresConfig.isRuntimeOptimizerEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)EXCHANGE_COMPRESSION, (String)"Enable compression in exchanges", (Boolean)featuresConfig.isExchangeCompressionEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)LEGACY_TIMESTAMP, (String)"Use legacy TIME & TIMESTAMP semantics (warning: this will be removed)", (Boolean)featuresConfig.isLegacyTimestamp(), (boolean)true), PropertyMetadata.booleanProperty((String)ENABLE_INTERMEDIATE_AGGREGATIONS, (String)"Enable the use of intermediate aggregations", (Boolean)featuresConfig.isEnableIntermediateAggregations(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_AGGREGATION_THROUGH_JOIN, (String)"Allow pushing aggregations below joins", (Boolean)featuresConfig.isPushAggregationThroughJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN, (String)"Push partial aggregations below joins", (Boolean)false, (boolean)false), PropertyMetadata.booleanProperty((String)PARSE_DECIMAL_LITERALS_AS_DOUBLE, (String)"Parse decimal literals as DOUBLE instead of DECIMAL", (Boolean)featuresConfig.isParseDecimalLiteralsAsDouble(), (boolean)false), PropertyMetadata.booleanProperty((String)FORCE_SINGLE_NODE_OUTPUT, (String)"Force single node output", (Boolean)featuresConfig.isForceSingleNodeOutput(), (boolean)true), new PropertyMetadata(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, "Experimental: Minimum output page size for filter and project operators", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getFilterAndProjectMinOutputPageSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.integerProperty((String)FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT, (String)"Experimental: Minimum output page row count for filter and project operators", (Integer)featuresConfig.getFilterAndProjectMinOutputPageRowCount(), (boolean)false), PropertyMetadata.booleanProperty((String)DISTRIBUTED_SORT, (String)"Parallelize sort across multiple nodes", (Boolean)featuresConfig.isDistributedSortEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_MARK_DISTINCT, (String)"Implement DISTINCT aggregations using MarkDistinct", (Boolean)featuresConfig.isUseMarkDistinct(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFER_PARTIAL_AGGREGATION, (String)"Prefer splitting aggregations into partial and final stages", (Boolean)featuresConfig.isPreferPartialAggregation(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_TOP_N_ROW_NUMBER, (String)"Use top N row number optimization", (Boolean)featuresConfig.isOptimizeTopNRowNumber(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_GROUPING_SETS, (String)"Maximum number of grouping sets in a GROUP BY", (Integer)featuresConfig.getMaxGroupingSets(), (boolean)true), PropertyMetadata.booleanProperty((String)LEGACY_UNNEST, (String)"Using legacy unnest semantic, where unnest(array(row)) will create one column of type row", (Boolean)featuresConfig.isLegacyUnnestArrayRows(), (boolean)false), PropertyMetadata.booleanProperty((String)STATISTICS_CPU_TIMER_ENABLED, (String)"Experimental: Enable cpu time tracking for automatic column statistics collection on write", (Boolean)taskManagerConfig.isStatisticsCpuTimerEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_STATS_CALCULATOR, (String)"Experimental: Enable statistics calculator", (Boolean)featuresConfig.isEnableStatsCalculator(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_STATS_COLLECTION_FOR_TEMPORARY_TABLE, (String)"Experimental: Enable statistics collection of temporary tables created for materialized exchange", (Boolean)featuresConfig.isEnableStatsCollectionForTemporaryTable(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_TASKS_PER_STAGE, (String)"Maximum number of tasks for a non source distributed stage", (Integer)taskManagerConfig.getMaxTasksPerStage(), (boolean)false), new PropertyMetadata(MAX_DRIVERS_PER_TASK, "Maximum number of drivers per task", (Type)IntegerType.INTEGER, Integer.class, null, false, value -> Math.min(taskManagerConfig.getMaxDriversPerTask(), SystemSessionProperties.validateNullablePositiveIntegerValue(value, MAX_DRIVERS_PER_TASK)), object -> object), PropertyMetadata.booleanProperty((String)IGNORE_STATS_CALCULATOR_FAILURES, (String)"Ignore statistics calculator failures", (Boolean)featuresConfig.isIgnoreStatsCalculatorFailures(), (boolean)false), PropertyMetadata.booleanProperty((String)PRINT_STATS_FOR_NON_JOIN_QUERY, (String)"Print stats and cost for non-join-query in plan", (Boolean)featuresConfig.isPrintStatsForNonJoinQuery(), (boolean)false), PropertyMetadata.booleanProperty((String)DEFAULT_FILTER_FACTOR_ENABLED, (String)"use a default filter factor for unknown filters in a filter node", (Boolean)featuresConfig.isDefaultFilterFactorEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_LIMIT_THROUGH_OUTER_JOIN, (String)"push limits to the outer side of an outer join", (Boolean)featuresConfig.isPushLimitThroughOuterJoin(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_CONCURRENT_MATERIALIZATIONS, (String)"Maximum number of materializing plan sections that can run concurrently", (Integer)featuresConfig.getMaxConcurrentMaterializations(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSHDOWN_SUBFIELDS_ENABLED, (String)"Experimental: enable subfield pruning", (Boolean)featuresConfig.isPushdownSubfieldsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSHDOWN_DEREFERENCE_ENABLED, (String)"Experimental: enable dereference pushdown", (Boolean)featuresConfig.isPushdownDereferenceEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)TABLE_WRITER_MERGE_OPERATOR_ENABLED, (String)"Experimental: enable table writer merge operator", (Boolean)featuresConfig.isTableWriterMergeOperatorEnabled(), (boolean)false), new PropertyMetadata(INDEX_LOADER_TIMEOUT, "Timeout for loading indexes for index joins", (Type)VarcharType.VARCHAR, Duration.class, (Object)featuresConfig.getIndexLoaderTimeout(), false, value -> Duration.valueOf((String)((String)value)), Duration::toString), PropertyMetadata.booleanProperty((String)OPTIMIZED_REPARTITIONING_ENABLED, (String)"Experimental: Use optimized repartitioning", (Boolean)featuresConfig.isOptimizedRepartitioningEnabled(), (boolean)false), new PropertyMetadata(AGGREGATION_PARTITIONING_MERGING_STRATEGY, String.format("Strategy to merge partition preference in aggregation node. Options are %s", Stream.of(FeaturesConfig.AggregationPartitioningMergingStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.AggregationPartitioningMergingStrategy.class, (Object)featuresConfig.getAggregationPartitioningMergingStrategy(), false, value -> FeaturesConfig.AggregationPartitioningMergingStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)LIST_BUILT_IN_FUNCTIONS_ONLY, (String)"Only List built-in functions in SHOW FUNCTIONS", (Boolean)featuresConfig.isListBuiltInFunctionsOnly(), (boolean)false), new PropertyMetadata(PARTITIONING_PRECISION_STRATEGY, String.format("The strategy to use to pick when to repartition. Options are %s", Stream.of(FeaturesConfig.PartitioningPrecisionStrategy.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, FeaturesConfig.PartitioningPrecisionStrategy.class, (Object)featuresConfig.getPartitioningPrecisionStrategy(), false, value -> FeaturesConfig.PartitioningPrecisionStrategy.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)EXPERIMENTAL_FUNCTIONS_ENABLED, (String)"Enable listing of functions marked as experimental", (Boolean)featuresConfig.isExperimentalFunctionsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_LEGACY_SCHEDULER, (String)"Use version of scheduler before refactorings for section retries", (Boolean)featuresConfig.isUseLegacyScheduler(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_COMMON_SUB_EXPRESSIONS, (String)"Extract and compute common sub-expressions in projection", (Boolean)featuresConfig.isOptimizeCommonSubExpressions(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFER_DISTRIBUTED_UNION, (String)"Prefer distributed union", (Boolean)featuresConfig.isPreferDistributedUnion(), (boolean)true), new PropertyMetadata(WARNING_HANDLING, String.format("The level of warning handling. Levels are %s", Stream.of(WarningHandlingLevel.values()).map(Enum::name).collect(Collectors.joining(","))), (Type)VarcharType.VARCHAR, WarningHandlingLevel.class, (Object)warningCollectorConfig.getWarningHandlingLevel(), false, value -> WarningHandlingLevel.valueOf(((String)value).toUpperCase()), Enum::name), PropertyMetadata.booleanProperty((String)OPTIMIZE_NULLS_IN_JOINS, (String)"Filter nulls from inner side of join", (Boolean)featuresConfig.isOptimizeNullsInJoin(), (boolean)false), new PropertyMetadata(TARGET_RESULT_SIZE, "Target result size for results being streamed from coordinator", (Type)VarcharType.VARCHAR, DataSize.class, null, false, value -> value != null ? DataSize.valueOf((String)((String)value)) : null, value -> value != null ? value.toString() : null), PropertyMetadata.booleanProperty((String)ENABLE_DYNAMIC_FILTERING, (String)"Experimental: Enable dynamic filtering", (Boolean)featuresConfig.isEnableDynamicFiltering(), (boolean)false), PropertyMetadata.integerProperty((String)DYNAMIC_FILTERING_MAX_PER_DRIVER_ROW_COUNT, (String)"Experimental: maximum number of build-side rows to be collected for dynamic filtering per-driver", (Integer)featuresConfig.getDynamicFilteringMaxPerDriverRowCount(), (boolean)false), new PropertyMetadata(DYNAMIC_FILTERING_MAX_PER_DRIVER_SIZE, "Experimental: maximum number of bytes to be collected for dynamic filtering per-driver", (Type)VarcharType.VARCHAR, DataSize.class, (Object)featuresConfig.getDynamicFilteringMaxPerDriverSize(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), PropertyMetadata.booleanProperty((String)FRAGMENT_RESULT_CACHING_ENABLED, (String)"Enable fragment result caching and read/write leaf fragment result pages from/to cache when applicable", (Boolean)featuresConfig.isFragmentResultCachingEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)LEGACY_TYPE_COERCION_WARNING_ENABLED, (String)"Enable warning for query relying on legacy type coercion", (Boolean)featuresConfig.isLegacyDateTimestampToVarcharCoercion(), (boolean)true), PropertyMetadata.booleanProperty((String)INLINE_SQL_FUNCTIONS, (String)"Inline SQL function definition at plan time", (Boolean)featuresConfig.isInlineSqlFunctions(), (boolean)false), PropertyMetadata.booleanProperty((String)REMOTE_FUNCTIONS_ENABLED, (String)"Allow remote functions", (Boolean)false, (boolean)false), PropertyMetadata.booleanProperty((String)CHECK_ACCESS_CONTROL_ON_UTILIZED_COLUMNS_ONLY, (String)"Apply access control rules on only those columns that are required to produce the query output", (Boolean)featuresConfig.isCheckAccessControlOnUtilizedColumnsOnly(), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static String getExecutionPolicy(Session session) {
        return session.getSystemProperty(EXECUTION_POLICY, String.class);
    }

    public static boolean isOptimizeHashGenerationEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_HASH_GENERATION, Boolean.class);
    }

    public static FeaturesConfig.JoinDistributionType getJoinDistributionType(Session session) {
        Boolean distributedJoin = session.getSystemProperty(DISTRIBUTED_JOIN, Boolean.class);
        if (distributedJoin != null) {
            if (!distributedJoin.booleanValue()) {
                return FeaturesConfig.JoinDistributionType.BROADCAST;
            }
            return FeaturesConfig.JoinDistributionType.PARTITIONED;
        }
        return session.getSystemProperty(JOIN_DISTRIBUTION_TYPE, FeaturesConfig.JoinDistributionType.class);
    }

    public static Optional<DataSize> getJoinMaxBroadcastTableSize(Session session) {
        return Optional.ofNullable(session.getSystemProperty(JOIN_MAX_BROADCAST_TABLE_SIZE, DataSize.class));
    }

    public static boolean isDistributedIndexJoinEnabled(Session session) {
        return session.getSystemProperty(DISTRIBUTED_INDEX_JOIN, Boolean.class);
    }

    public static int getHashPartitionCount(Session session) {
        return session.getSystemProperty(HASH_PARTITION_COUNT, Integer.class);
    }

    public static String getPartitioningProviderCatalog(Session session) {
        return session.getSystemProperty(PARTITIONING_PROVIDER_CATALOG, String.class);
    }

    public static QueryManagerConfig.ExchangeMaterializationStrategy getExchangeMaterializationStrategy(Session session) {
        return session.getSystemProperty(EXCHANGE_MATERIALIZATION_STRATEGY, QueryManagerConfig.ExchangeMaterializationStrategy.class);
    }

    public static boolean isUseStreamingExchangeForMarkDistinctEnabled(Session session) {
        return session.getSystemProperty(USE_STREAMING_EXCHANGE_FOR_MARK_DISTINCT, Boolean.class);
    }

    public static boolean isGroupedExecutionEnabled(Session session) {
        return session.getSystemProperty(GROUPED_EXECUTION, Boolean.class);
    }

    public static boolean isRecoverableGroupedExecutionEnabled(Session session) {
        return session.getSystemProperty(RECOVERABLE_GROUPED_EXECUTION, Boolean.class);
    }

    public static double getMaxFailedTaskPercentage(Session session) {
        return session.getSystemProperty(MAX_FAILED_TASK_PERCENTAGE, Double.class);
    }

    public static int getMaxStageRetries(Session session) {
        return session.getSystemProperty(MAX_STAGE_RETRIES, Integer.class);
    }

    public static boolean preferStreamingOperators(Session session) {
        return session.getSystemProperty(PREFER_STREAMING_OPERATORS, Boolean.class);
    }

    public static int getTaskWriterCount(Session session) {
        return session.getSystemProperty(TASK_WRITER_COUNT, Integer.class);
    }

    public static int getTaskPartitionedWriterCount(Session session) {
        Integer partitionedWriterCount = session.getSystemProperty(TASK_PARTITIONED_WRITER_COUNT, Integer.class);
        if (partitionedWriterCount != null) {
            return partitionedWriterCount;
        }
        return SystemSessionProperties.getTaskWriterCount(session);
    }

    public static boolean isRedistributeWrites(Session session) {
        return session.getSystemProperty(REDISTRIBUTE_WRITES, Boolean.class);
    }

    public static boolean isScaleWriters(Session session) {
        return session.getSystemProperty(SCALE_WRITERS, Boolean.class);
    }

    public static DataSize getWriterMinSize(Session session) {
        return session.getSystemProperty(WRITER_MIN_SIZE, DataSize.class);
    }

    public static boolean isOptimizedScaleWriterProducerBuffer(Session session) {
        return session.getSystemProperty(OPTIMIZED_SCALE_WRITER_PRODUCER_BUFFER, Boolean.class);
    }

    public static boolean isPushTableWriteThroughUnion(Session session) {
        return session.getSystemProperty(PUSH_TABLE_WRITE_THROUGH_UNION, Boolean.class);
    }

    public static int getTaskConcurrency(Session session) {
        return session.getSystemProperty(TASK_CONCURRENCY, Integer.class);
    }

    public static boolean isShareIndexLoading(Session session) {
        return session.getSystemProperty(TASK_SHARE_INDEX_LOADING, Boolean.class);
    }

    public static boolean isDictionaryAggregationEnabled(Session session) {
        return session.getSystemProperty(DICTIONARY_AGGREGATION, Boolean.class);
    }

    public static boolean isOptimizeMetadataQueries(Session session) {
        return session.getSystemProperty(OPTIMIZE_METADATA_QUERIES, Boolean.class);
    }

    public static DataSize getQueryMaxMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_MEMORY, DataSize.class);
    }

    public static DataSize getQueryMaxMemoryPerNode(Session session) {
        return session.getSystemProperty(QUERY_MAX_MEMORY_PER_NODE, DataSize.class);
    }

    public static DataSize getQueryMaxBroadcastMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_BROADCAST_MEMORY, DataSize.class);
    }

    public static DataSize getQueryMaxTotalMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_TOTAL_MEMORY, DataSize.class);
    }

    public static DataSize getQueryMaxTotalMemoryPerNode(Session session) {
        return session.getSystemProperty(QUERY_MAX_TOTAL_MEMORY_PER_NODE, DataSize.class);
    }

    public static Duration getQueryMaxRunTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_RUN_TIME, Duration.class);
    }

    public static Duration getQueryMaxExecutionTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_EXECUTION_TIME, Duration.class);
    }

    public static boolean resourceOvercommit(Session session) {
        return session.getSystemProperty(RESOURCE_OVERCOMMIT, Boolean.class);
    }

    public static int getQueryMaxStageCount(Session session) {
        return session.getSystemProperty(QUERY_MAX_STAGE_COUNT, Integer.class);
    }

    public static boolean planWithTableNodePartitioning(Session session) {
        return session.getSystemProperty(PLAN_WITH_TABLE_NODE_PARTITIONING, Boolean.class);
    }

    public static boolean isFastInequalityJoin(Session session) {
        return session.getSystemProperty(FAST_INEQUALITY_JOINS, Boolean.class);
    }

    public static FeaturesConfig.JoinReorderingStrategy getJoinReorderingStrategy(Session session) {
        Boolean reorderJoins = session.getSystemProperty(REORDER_JOINS, Boolean.class);
        if (reorderJoins != null) {
            if (!reorderJoins.booleanValue()) {
                return FeaturesConfig.JoinReorderingStrategy.NONE;
            }
            return FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS;
        }
        return session.getSystemProperty(JOIN_REORDERING_STRATEGY, FeaturesConfig.JoinReorderingStrategy.class);
    }

    public static FeaturesConfig.PartialMergePushdownStrategy getPartialMergePushdownStrategy(Session session) {
        return session.getSystemProperty(PARTIAL_MERGE_PUSHDOWN_STRATEGY, FeaturesConfig.PartialMergePushdownStrategy.class);
    }

    public static int getMaxReorderedJoins(Session session) {
        return session.getSystemProperty(MAX_REORDERED_JOINS, Integer.class);
    }

    public static boolean isColocatedJoinEnabled(Session session) {
        return session.getSystemProperty(COLOCATED_JOIN, Boolean.class);
    }

    public static boolean isSpatialJoinEnabled(Session session) {
        return session.getSystemProperty(SPATIAL_JOIN, Boolean.class);
    }

    public static Optional<String> getSpatialPartitioningTableName(Session session) {
        return Optional.ofNullable(session.getSystemProperty(SPATIAL_PARTITIONING_TABLE_NAME, String.class));
    }

    public static OptionalInt getConcurrentLifespansPerNode(Session session) {
        Integer result = session.getSystemProperty(CONCURRENT_LIFESPANS_PER_NODE, Integer.class);
        if (result == 0) {
            return OptionalInt.empty();
        }
        Preconditions.checkArgument((result > 0 ? 1 : 0) != 0, (Object)"Concurrent lifespans per node must be positive if set to non-zero");
        return OptionalInt.of(result);
    }

    public static int getInitialSplitsPerNode(Session session) {
        return session.getSystemProperty(INITIAL_SPLITS_PER_NODE, Integer.class);
    }

    public static int getQueryPriority(Session session) {
        Integer priority = session.getSystemProperty(QUERY_PRIORITY, Integer.class);
        Preconditions.checkArgument((priority > 0 ? 1 : 0) != 0, (Object)"Query priority must be positive");
        return priority;
    }

    public static Duration getSplitConcurrencyAdjustmentInterval(Session session) {
        return session.getSystemProperty(SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, Duration.class);
    }

    public static Duration getQueryMaxCpuTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_CPU_TIME, Duration.class);
    }

    public static DataSize getQueryMaxScanRawInputBytes(Session session) {
        return session.getSystemProperty(QUERY_MAX_SCAN_RAW_INPUT_BYTES, DataSize.class);
    }

    public static DataSize getQueryMaxOutputSize(Session session) {
        return session.getSystemProperty(QUERY_MAX_OUTPUT_SIZE, DataSize.class);
    }

    public static boolean isSpillEnabled(Session session) {
        return session.getSystemProperty(SPILL_ENABLED, Boolean.class);
    }

    public static boolean isJoinSpillingEnabled(Session session) {
        return session.getSystemProperty(JOIN_SPILL_ENABLED, Boolean.class);
    }

    public static DataSize getAggregationOperatorUnspillMemoryLimit(Session session) {
        DataSize memoryLimitForMerge = session.getSystemProperty(AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, DataSize.class);
        Preconditions.checkArgument((memoryLimitForMerge.toBytes() >= 0L ? 1 : 0) != 0, (String)"%s must be positive", (Object)AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT);
        return memoryLimitForMerge;
    }

    public static boolean isOptimizeDistinctAggregationEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_DISTINCT_AGGREGATIONS, Boolean.class);
    }

    public static boolean isLegacyRowFieldOrdinalAccessEnabled(Session session) {
        return session.getSystemProperty(LEGACY_ROW_FIELD_ORDINAL_ACCESS, Boolean.class);
    }

    public static boolean isLegacyMapSubscript(Session session) {
        return session.getSystemProperty(LEGACY_MAP_SUBSCRIPT, Boolean.class);
    }

    public static boolean isNewOptimizerEnabled(Session session) {
        return session.getSystemProperty(ITERATIVE_OPTIMIZER, Boolean.class);
    }

    public static boolean isRuntimeOptimizerEnabled(Session session) {
        return session.getSystemProperty(RUNTIME_OPTIMIZER_ENABLED, Boolean.class);
    }

    @Deprecated
    public static boolean isLegacyTimestamp(Session session) {
        return session.getSystemProperty(LEGACY_TIMESTAMP, Boolean.class);
    }

    public static Duration getOptimizerTimeout(Session session) {
        return session.getSystemProperty(ITERATIVE_OPTIMIZER_TIMEOUT, Duration.class);
    }

    public static boolean isExchangeCompressionEnabled(Session session) {
        return session.getSystemProperty(EXCHANGE_COMPRESSION, Boolean.class);
    }

    public static boolean isEnableIntermediateAggregations(Session session) {
        return session.getSystemProperty(ENABLE_INTERMEDIATE_AGGREGATIONS, Boolean.class);
    }

    public static boolean shouldPushAggregationThroughJoin(Session session) {
        return session.getSystemProperty(PUSH_AGGREGATION_THROUGH_JOIN, Boolean.class);
    }

    public static boolean isPushAggregationThroughJoin(Session session) {
        return session.getSystemProperty(PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN, Boolean.class);
    }

    public static boolean isParseDecimalLiteralsAsDouble(Session session) {
        return session.getSystemProperty(PARSE_DECIMAL_LITERALS_AS_DOUBLE, Boolean.class);
    }

    public static boolean isForceSingleNodeOutput(Session session) {
        return session.getSystemProperty(FORCE_SINGLE_NODE_OUTPUT, Boolean.class);
    }

    public static DataSize getFilterAndProjectMinOutputPageSize(Session session) {
        return session.getSystemProperty(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, DataSize.class);
    }

    public static int getFilterAndProjectMinOutputPageRowCount(Session session) {
        return session.getSystemProperty(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT, Integer.class);
    }

    public static boolean useMarkDistinct(Session session) {
        return session.getSystemProperty(USE_MARK_DISTINCT, Boolean.class);
    }

    public static boolean preferPartialAggregation(Session session) {
        return session.getSystemProperty(PREFER_PARTIAL_AGGREGATION, Boolean.class);
    }

    public static boolean isOptimizeTopNRowNumber(Session session) {
        return session.getSystemProperty(OPTIMIZE_TOP_N_ROW_NUMBER, Boolean.class);
    }

    public static boolean isDistributedSortEnabled(Session session) {
        return session.getSystemProperty(DISTRIBUTED_SORT, Boolean.class);
    }

    public static int getMaxGroupingSets(Session session) {
        return session.getSystemProperty(MAX_GROUPING_SETS, Integer.class);
    }

    public static boolean isLegacyUnnest(Session session) {
        return session.getSystemProperty(LEGACY_UNNEST, Boolean.class);
    }

    public static OptionalInt getMaxDriversPerTask(Session session) {
        Integer value = session.getSystemProperty(MAX_DRIVERS_PER_TASK, Integer.class);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    public static int getMaxTasksPerStage(Session session) {
        return session.getSystemProperty(MAX_TASKS_PER_STAGE, Integer.class);
    }

    private static Integer validateValueIsPowerOfTwo(Object value, String property) {
        Number number = (Number)value;
        if (number == null) {
            return null;
        }
        int intValue = number.intValue();
        if (Integer.bitCount(intValue) != 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be a power of 2: %s", property, intValue));
        }
        return intValue;
    }

    private static Integer validateNullablePositiveIntegerValue(Object value, String property) {
        return SystemSessionProperties.validateIntegerValue(value, property, 1, true);
    }

    private static Integer validateIntegerValue(Object value, String property, int lowerBoundIncluded, boolean allowNull) {
        if (value == null && !allowNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be non-null", property));
        }
        if (value == null) {
            return null;
        }
        int intValue = ((Number)value).intValue();
        if (intValue < lowerBoundIncluded) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be equal or greater than %s", property, lowerBoundIncluded));
        }
        return intValue;
    }

    public static boolean isStatisticsCpuTimerEnabled(Session session) {
        return session.getSystemProperty(STATISTICS_CPU_TIMER_ENABLED, Boolean.class);
    }

    public static boolean isEnableStatsCalculator(Session session) {
        return session.getSystemProperty(ENABLE_STATS_CALCULATOR, Boolean.class);
    }

    public static boolean isEnableStatsCollectionForTemporaryTable(Session session) {
        return session.getSystemProperty(ENABLE_STATS_COLLECTION_FOR_TEMPORARY_TABLE, Boolean.class);
    }

    public static boolean isIgnoreStatsCalculatorFailures(Session session) {
        return session.getSystemProperty(IGNORE_STATS_CALCULATOR_FAILURES, Boolean.class);
    }

    public static boolean isPrintStatsForNonJoinQuery(Session session) {
        return session.getSystemProperty(PRINT_STATS_FOR_NON_JOIN_QUERY, Boolean.class);
    }

    public static boolean isDefaultFilterFactorEnabled(Session session) {
        return session.getSystemProperty(DEFAULT_FILTER_FACTOR_ENABLED, Boolean.class);
    }

    public static boolean isPushLimitThroughOuterJoin(Session session) {
        return session.getSystemProperty(PUSH_LIMIT_THROUGH_OUTER_JOIN, Boolean.class);
    }

    public static int getMaxConcurrentMaterializations(Session session) {
        return session.getSystemProperty(MAX_CONCURRENT_MATERIALIZATIONS, Integer.class);
    }

    public static boolean isPushdownSubfieldsEnabled(Session session) {
        return session.getSystemProperty(PUSHDOWN_SUBFIELDS_ENABLED, Boolean.class);
    }

    public static boolean isPushdownDereferenceEnabled(Session session) {
        return session.getSystemProperty(PUSHDOWN_DEREFERENCE_ENABLED, Boolean.class);
    }

    public static boolean isTableWriterMergeOperatorEnabled(Session session) {
        return session.getSystemProperty(TABLE_WRITER_MERGE_OPERATOR_ENABLED, Boolean.class);
    }

    public static Duration getIndexLoaderTimeout(Session session) {
        return session.getSystemProperty(INDEX_LOADER_TIMEOUT, Duration.class);
    }

    public static boolean isOptimizedRepartitioningEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZED_REPARTITIONING_ENABLED, Boolean.class);
    }

    public static FeaturesConfig.AggregationPartitioningMergingStrategy getAggregationPartitioningMergingStrategy(Session session) {
        return session.getSystemProperty(AGGREGATION_PARTITIONING_MERGING_STRATEGY, FeaturesConfig.AggregationPartitioningMergingStrategy.class);
    }

    public static boolean isListBuiltInFunctionsOnly(Session session) {
        return session.getSystemProperty(LIST_BUILT_IN_FUNCTIONS_ONLY, Boolean.class);
    }

    public static boolean isExactPartitioningPreferred(Session session) {
        return session.getSystemProperty(PARTITIONING_PRECISION_STRATEGY, FeaturesConfig.PartitioningPrecisionStrategy.class) == FeaturesConfig.PartitioningPrecisionStrategy.PREFER_EXACT_PARTITIONING;
    }

    public static boolean isExperimentalFunctionsEnabled(Session session) {
        return session.getSystemProperty(EXPERIMENTAL_FUNCTIONS_ENABLED, Boolean.class);
    }

    public static boolean isUseLegacyScheduler(Session session) {
        return session.getSystemProperty(USE_LEGACY_SCHEDULER, Boolean.class);
    }

    public static boolean isOptimizeCommonSubExpressions(Session session) {
        return session.getSystemProperty(OPTIMIZE_COMMON_SUB_EXPRESSIONS, Boolean.class);
    }

    public static boolean isPreferDistributedUnion(Session session) {
        return session.getSystemProperty(PREFER_DISTRIBUTED_UNION, Boolean.class);
    }

    public static WarningHandlingLevel getWarningHandlingLevel(Session session) {
        return session.getSystemProperty(WARNING_HANDLING, WarningHandlingLevel.class);
    }

    public static boolean isOptimizeNullsInJoin(Session session) {
        return session.getSystemProperty(OPTIMIZE_NULLS_IN_JOINS, Boolean.class);
    }

    public static Optional<DataSize> getTargetResultSize(Session session) {
        return Optional.ofNullable(session.getSystemProperty(TARGET_RESULT_SIZE, DataSize.class));
    }

    public static boolean isEnableDynamicFiltering(Session session) {
        return session.getSystemProperty(ENABLE_DYNAMIC_FILTERING, Boolean.class);
    }

    public static int getDynamicFilteringMaxPerDriverRowCount(Session session) {
        return session.getSystemProperty(DYNAMIC_FILTERING_MAX_PER_DRIVER_ROW_COUNT, Integer.class);
    }

    public static DataSize getDynamicFilteringMaxPerDriverSize(Session session) {
        return session.getSystemProperty(DYNAMIC_FILTERING_MAX_PER_DRIVER_SIZE, DataSize.class);
    }

    public static boolean isFragmentResultCachingEnabled(Session session) {
        return session.getSystemProperty(FRAGMENT_RESULT_CACHING_ENABLED, Boolean.class);
    }

    public static boolean isLegacyTypeCoercionWarningEnabled(Session session) {
        return session.getSystemProperty(LEGACY_TYPE_COERCION_WARNING_ENABLED, Boolean.class);
    }

    public static boolean isInlineSqlFunctions(Session session) {
        return session.getSystemProperty(INLINE_SQL_FUNCTIONS, Boolean.class);
    }

    public static boolean isRemoteFunctionsEnabled(Session session) {
        return session.getSystemProperty(REMOTE_FUNCTIONS_ENABLED, Boolean.class);
    }

    public static boolean isCheckAccessControlOnUtilizedColumnsOnly(Session session) {
        return session.getSystemProperty(CHECK_ACCESS_CONTROL_ON_UTILIZED_COLUMNS_ONLY, Boolean.class);
    }
}

