/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.DropFunction;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DropFunctionTask
implements DataDefinitionTask<DropFunction> {
    private final SqlParser sqlParser;

    @Inject
    public DropFunctionTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "DROP FUNCTION";
    }

    @Override
    public String explain(DropFunction statement, List<Expression> parameters) {
        return "DROP FUNCTION " + statement.getFunctionName();
    }

    @Override
    public ListenableFuture<?> execute(DropFunction statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Analyzer analyzer = new Analyzer(stateMachine.getSession(), metadata, this.sqlParser, accessControl, Optional.empty(), parameters, stateMachine.getWarningCollector());
        analyzer.analyze((Statement)statement);
        metadata.getFunctionAndTypeManager().dropFunction(FunctionAndTypeManager.qualifyFunctionName(statement.getFunctionName()), statement.getParameterTypes().map(types -> (ImmutableList)types.stream().map(TypeSignature::parseTypeSignature).collect(ImmutableList.toImmutableList())), statement.isExists());
        return Futures.immediateFuture(null);
    }
}

