/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class SetSessionTask
implements DataDefinitionTask<SetSession> {
    @Override
    public String getName() {
        return "SET SESSION";
    }

    @Override
    public ListenableFuture<?> execute(SetSession statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Object objectValue;
        PropertyMetadata<?> propertyMetadata;
        Session session = stateMachine.getSession();
        QualifiedName propertyName = statement.getName();
        List parts = propertyName.getParts();
        if (parts.size() > 2) {
            throw new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", propertyName);
        }
        if (parts.size() == 1) {
            accessControl.checkCanSetSystemSessionProperty(session.getIdentity(), session.getAccessControlContext(), (String)parts.get(0));
            propertyMetadata = metadata.getSessionPropertyManager().getSystemSessionPropertyMetadata((String)parts.get(0)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", statement.getName()));
        } else {
            ConnectorId connectorId = metadata.getCatalogHandle(stateMachine.getSession(), (String)parts.get(0)).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "Catalog %s does not exist", parts.get(0)));
            accessControl.checkCanSetCatalogSessionProperty(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), (String)parts.get(0), (String)parts.get(1));
            propertyMetadata = metadata.getSessionPropertyManager().getConnectorSessionPropertyMetadata(connectorId, (String)parts.get(1)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", statement.getName()));
        }
        Type type = propertyMetadata.getSqlType();
        try {
            objectValue = SessionPropertyManager.evaluatePropertyValue(statement.getValue(), type, session, metadata, parameters);
        }
        catch (SemanticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unable to set session property '%s' to '%s': %s", propertyName, statement.getValue(), e.getMessage()));
        }
        String value = SessionPropertyManager.serializeSessionProperty(type, objectValue);
        propertyMetadata.decode(objectValue);
        stateMachine.addSetSessionProperties(propertyName.toString(), value);
        return Futures.immediateFuture(null);
    }
}

