/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.ClientBuffer;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.SerializedPageReference;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;

public class BroadcastOutputBuffer
implements OutputBuffer {
    private final String taskInstanceId;
    private final StateMachine<BufferState> state;
    private final OutputBufferMemoryManager memoryManager;
    @GuardedBy(value="this")
    private OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(OutputBuffers.BufferType.BROADCAST);
    @GuardedBy(value="this")
    private final Map<OutputBuffers.OutputBufferId, ClientBuffer> buffers = new ConcurrentHashMap<OutputBuffers.OutputBufferId, ClientBuffer>();
    @GuardedBy(value="this")
    private final List<SerializedPageReference> initialPagesForNewBuffers = new ArrayList<SerializedPageReference>();
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();
    private final AtomicLong totalBufferedPages = new AtomicLong();
    private final ConcurrentMap<Lifespan, AtomicLong> outstandingPageCountPerLifespan = new ConcurrentHashMap<Lifespan, AtomicLong>();
    private final Set<Lifespan> noMorePagesForLifespan = ConcurrentHashMap.newKeySet();
    private volatile Consumer<Lifespan> lifespanCompletionCallback;

    public BroadcastOutputBuffer(String taskInstanceId, StateMachine<BufferState> state, DataSize maxBufferSize, Supplier<LocalMemoryContext> systemMemoryContextSupplier, Executor notificationExecutor) {
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.memoryManager = new OutputBufferMemoryManager(Objects.requireNonNull(maxBufferSize, "maxBufferSize is null").toBytes(), Objects.requireNonNull(systemMemoryContextSupplier, "systemMemoryContextSupplier is null"), Objects.requireNonNull(notificationExecutor, "notificationExecutor is null"));
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    @Override
    public double getUtilization() {
        return this.memoryManager.getUtilization();
    }

    @Override
    public boolean isOverutilized() {
        return this.memoryManager.isOverutilized();
    }

    @Override
    public OutputBufferInfo getInfo() {
        BufferState state = this.state.get();
        Collection<ClientBuffer> buffers = this.buffers.values();
        return new OutputBufferInfo("BROADCAST", state, state.canAddBuffers(), state.canAddPages(), this.memoryManager.getBufferedBytes(), this.totalBufferedPages.get(), this.totalRowsAdded.get(), this.totalPagesAdded.get(), (List)buffers.stream().map(ClientBuffer::getInfo).collect(ImmutableList.toImmutableList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not set output buffers while holding a lock on this");
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        BroadcastOutputBuffer broadcastOutputBuffer = this;
        synchronized (broadcastOutputBuffer) {
            BufferState state = this.state.get();
            if (state.isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
                return;
            }
            this.outputBuffers.checkValidTransition(newOutputBuffers);
            this.outputBuffers = newOutputBuffers;
            for (Map.Entry<OutputBuffers.OutputBufferId, Integer> entry : this.outputBuffers.getBuffers().entrySet()) {
                if (this.buffers.containsKey(entry.getKey())) continue;
                ClientBuffer buffer = this.getBuffer(entry.getKey());
                if (state.canAddPages()) continue;
                buffer.setNoMorePages();
            }
            if (this.outputBuffers.isNoMoreBufferIds()) {
                this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_BUFFERS);
                this.state.compareAndSet(BufferState.NO_MORE_PAGES, BufferState.FLUSHING);
            }
        }
        if (!this.state.get().canAddBuffers()) {
            this.noMoreBuffers();
        }
        this.checkFlushComplete();
    }

    @Override
    public ListenableFuture<?> isFull() {
        return this.memoryManager.getBufferBlockedFuture();
    }

    @Override
    public void registerLifespanCompletionCallback(Consumer<Lifespan> callback) {
        Preconditions.checkState((this.lifespanCompletionCallback == null ? 1 : 0) != 0, (Object)"lifespanCompletionCallback is already set");
        this.lifespanCompletionCallback = Objects.requireNonNull(callback, "callback is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Lifespan lifespan, List<SerializedPage> pages) {
        Collection<ClientBuffer> buffers;
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not enqueue pages while holding a lock on this");
        Objects.requireNonNull(pages, "pages is null");
        Preconditions.checkState((this.lifespanCompletionCallback != null ? 1 : 0) != 0, (Object)"lifespanCompletionCallback must be set before enqueueing data");
        if (!this.state.get().canAddPages() || this.noMorePagesForLifespan.contains(lifespan)) {
            return;
        }
        long bytesAdded = pages.stream().mapToLong(SerializedPage::getRetainedSizeInBytes).sum();
        this.memoryManager.updateMemoryUsage(bytesAdded);
        long rowCount = pages.stream().mapToLong(SerializedPage::getPositionCount).sum();
        this.totalRowsAdded.addAndGet(rowCount);
        this.totalPagesAdded.addAndGet(pages.size());
        this.totalBufferedPages.addAndGet(pages.size());
        this.outstandingPageCountPerLifespan.computeIfAbsent(lifespan, ignore -> new AtomicLong()).addAndGet(pages.size());
        List serializedPageReferences = (List)pages.stream().map(pageSplit -> new SerializedPageReference((SerializedPage)pageSplit, 1, () -> this.dereferencePage((SerializedPage)pageSplit, lifespan))).collect(ImmutableList.toImmutableList());
        BroadcastOutputBuffer broadcastOutputBuffer = this;
        synchronized (broadcastOutputBuffer) {
            if (this.state.get().canAddBuffers()) {
                serializedPageReferences.forEach(SerializedPageReference::addReference);
                this.initialPagesForNewBuffers.addAll(serializedPageReferences);
            }
            buffers = this.safeGetBuffersSnapshot();
        }
        buffers.forEach(partition -> partition.enqueuePages(serializedPageReferences));
        serializedPageReferences.forEach(SerializedPageReference::dereferencePage);
    }

    @Override
    public void enqueue(Lifespan lifespan, int partitionNumber, List<SerializedPage> pages) {
        Preconditions.checkState((partitionNumber == 0 ? 1 : 0) != 0, (Object)"Expected partition number to be zero");
        this.enqueue(lifespan, pages);
    }

    @Override
    public ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId outputBufferId, long startingSequenceId, DataSize maxSize) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not get pages while holding a lock on this");
        Objects.requireNonNull(outputBufferId, "outputBufferId is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        return this.getBuffer(outputBufferId).getPages(startingSequenceId, maxSize);
    }

    @Override
    public void acknowledge(OutputBuffers.OutputBufferId bufferId, long sequenceId) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not acknowledge pages while holding a lock on this");
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.getBuffer(bufferId).acknowledgePages(sequenceId);
    }

    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not abort while holding a lock on this");
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.getBuffer(bufferId).destroy();
        this.checkFlushComplete();
    }

    @Override
    public void setNoMorePages() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not set no more pages while holding a lock on this");
        this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_PAGES);
        this.state.compareAndSet(BufferState.NO_MORE_BUFFERS, BufferState.FLUSHING);
        this.memoryManager.setNoBlockOnFull();
        this.safeGetBuffersSnapshot().forEach(ClientBuffer::setNoMorePages);
        this.checkFlushComplete();
    }

    @Override
    public void destroy() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not destroy while holding a lock on this");
        if (this.state.setIf(BufferState.FINISHED, oldState -> !oldState.isTerminal())) {
            this.noMoreBuffers();
            this.safeGetBuffersSnapshot().forEach(ClientBuffer::destroy);
            this.memoryManager.setNoBlockOnFull();
            this.forceFreeMemory();
        }
    }

    @Override
    public void fail() {
        if (this.state.setIf(BufferState.FAILED, oldState -> !oldState.isTerminal())) {
            this.memoryManager.setNoBlockOnFull();
            this.forceFreeMemory();
        }
    }

    @Override
    public void setNoMorePagesForLifespan(Lifespan lifespan) {
        Objects.requireNonNull(lifespan, "lifespan is null");
        this.noMorePagesForLifespan.add(lifespan);
    }

    @Override
    public boolean isFinishedForLifespan(Lifespan lifespan) {
        if (!this.noMorePagesForLifespan.contains(lifespan)) {
            return false;
        }
        AtomicLong outstandingPageCount = (AtomicLong)this.outstandingPageCountPerLifespan.get(lifespan);
        return outstandingPageCount == null || outstandingPageCount.get() == 0L;
    }

    @Override
    public long getPeakMemoryUsage() {
        return this.memoryManager.getPeakMemoryUsage();
    }

    @VisibleForTesting
    void forceFreeMemory() {
        this.memoryManager.close();
    }

    private synchronized ClientBuffer getBuffer(OutputBuffers.OutputBufferId id) {
        ClientBuffer buffer = this.buffers.get(id);
        if (buffer != null) {
            return buffer;
        }
        BufferState state = this.state.get();
        Preconditions.checkState((state.canAddBuffers() || !this.outputBuffers.isNoMoreBufferIds() ? 1 : 0) != 0, (Object)"No more buffers already set");
        buffer = new ClientBuffer(this.taskInstanceId, id);
        if (state != BufferState.FAILED) {
            buffer.enqueuePages(this.initialPagesForNewBuffers);
            if (!state.canAddPages()) {
                buffer.setNoMorePages();
            }
            if (state == BufferState.FINISHED) {
                buffer.destroy();
            }
        }
        this.buffers.put(id, buffer);
        return buffer;
    }

    private synchronized Collection<ClientBuffer> safeGetBuffersSnapshot() {
        return ImmutableList.copyOf(this.buffers.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noMoreBuffers() {
        ImmutableList pages;
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not set no more buffers while holding a lock on this");
        BroadcastOutputBuffer broadcastOutputBuffer = this;
        synchronized (broadcastOutputBuffer) {
            pages = ImmutableList.copyOf(this.initialPagesForNewBuffers);
            this.initialPagesForNewBuffers.clear();
            if (this.outputBuffers.isNoMoreBufferIds()) {
                Sets.SetView undeclaredCreatedBuffers = Sets.difference(this.buffers.keySet(), this.outputBuffers.getBuffers().keySet());
                Preconditions.checkState((boolean)undeclaredCreatedBuffers.isEmpty(), (String)"Final output buffers does not contain all created buffer ids: %s", (Object)undeclaredCreatedBuffers);
            }
        }
        pages.forEach(SerializedPageReference::dereferencePage);
    }

    private void checkFlushComplete() {
        if (this.state.get() != BufferState.FLUSHING && this.state.get() != BufferState.NO_MORE_BUFFERS) {
            return;
        }
        if (this.safeGetBuffersSnapshot().stream().allMatch(ClientBuffer::isDestroyed)) {
            this.destroy();
        }
    }

    @VisibleForTesting
    OutputBufferMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    private void dereferencePage(SerializedPage pageSplit, Lifespan lifespan) {
        long outstandingPageCount = ((AtomicLong)this.outstandingPageCountPerLifespan.get(lifespan)).decrementAndGet();
        if (outstandingPageCount == 0L && this.noMorePagesForLifespan.contains(lifespan)) {
            Preconditions.checkState((this.lifespanCompletionCallback != null ? 1 : 0) != 0, (Object)"lifespanCompletionCallback is not null");
            this.lifespanCompletionCallback.accept(lifespan);
        }
        Preconditions.checkState((this.totalBufferedPages.decrementAndGet() >= 0L ? 1 : 0) != 0);
        this.memoryManager.updateMemoryUsage(-pageSplit.getRetainedSizeInBytes());
    }
}

