/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public class FixedBucketNodeMap
extends BucketNodeMap {
    private final List<InternalNode> bucketToNode;
    private final boolean cacheable;

    public FixedBucketNodeMap(ToIntFunction<Split> splitToBucket, List<InternalNode> bucketToNode, boolean cacheable) {
        super(splitToBucket);
        Objects.requireNonNull(bucketToNode, "bucketToNode is null");
        this.bucketToNode = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketToNode, "bucketToNode is null"));
        this.cacheable = cacheable;
    }

    @Override
    public Optional<InternalNode> getAssignedNode(int bucketedId) {
        return Optional.of(this.bucketToNode.get(bucketedId));
    }

    @Override
    public boolean isBucketCacheable(int bucketedId) {
        return this.cacheable;
    }

    @Override
    public int getBucketCount() {
        return this.bucketToNode.size();
    }

    @Override
    public void assignOrUpdateBucketToNode(int bucketedId, InternalNode node, boolean cacheable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean hasInitialMap() {
        return true;
    }

    @Override
    public Optional<List<InternalNode>> getBucketToNode() {
        return Optional.of(this.bucketToNode);
    }
}

