/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.NetworkLocation;
import com.facebook.presto.execution.scheduler.NetworkLocationCache;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeAssignmentStats;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.ResettableRandomizedIterator;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelector;
import com.facebook.presto.execution.scheduler.nodeSelection.SimpleNodeSelector;
import com.facebook.presto.execution.scheduler.nodeSelection.TopologyAwareNodeSelector;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.spi.SplitContext;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class NodeScheduler {
    private final NetworkLocationCache networkLocationCache;
    private final List<CounterStat> topologicalSplitCounters;
    private final List<String> networkLocationSegmentNames;
    private final InternalNodeManager nodeManager;
    private final NodeSelectionStats nodeSelectionStats;
    private final int minCandidates;
    private final boolean includeCoordinator;
    private final int maxSplitsPerNode;
    private final int maxPendingSplitsPerTask;
    private final NodeTaskMap nodeTaskMap;
    private final boolean useNetworkTopology;
    private final Duration nodeMapRefreshInterval;

    @Inject
    public NodeScheduler(NetworkTopology networkTopology, InternalNodeManager nodeManager, NodeSelectionStats nodeSelectionStats, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap) {
        this(new NetworkLocationCache(networkTopology), networkTopology, nodeManager, nodeSelectionStats, config, nodeTaskMap, new Duration(5.0, TimeUnit.SECONDS));
    }

    public NodeScheduler(NetworkLocationCache networkLocationCache, NetworkTopology networkTopology, InternalNodeManager nodeManager, NodeSelectionStats nodeSelectionStats, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap, Duration nodeMapRefreshInterval) {
        this.networkLocationCache = networkLocationCache;
        this.nodeManager = nodeManager;
        this.nodeSelectionStats = Objects.requireNonNull(nodeSelectionStats, "nodeSelectionStats is null");
        this.minCandidates = config.getMinCandidates();
        this.includeCoordinator = config.isIncludeCoordinator();
        this.maxSplitsPerNode = config.getMaxSplitsPerNode();
        this.maxPendingSplitsPerTask = config.getMaxPendingSplitsPerTask();
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        Preconditions.checkArgument((this.maxSplitsPerNode >= this.maxPendingSplitsPerTask ? 1 : 0) != 0, (Object)"maxSplitsPerNode must be > maxPendingSplitsPerTask");
        this.useNetworkTopology = !config.getNetworkTopology().equals("legacy");
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.useNetworkTopology) {
            this.networkLocationSegmentNames = ImmutableList.copyOf(networkTopology.getLocationSegmentNames());
            for (int i = 0; i < this.networkLocationSegmentNames.size() + 1; ++i) {
                builder.add((Object)new CounterStat());
            }
        } else {
            this.networkLocationSegmentNames = ImmutableList.of();
        }
        this.topologicalSplitCounters = builder.build();
        this.nodeMapRefreshInterval = Objects.requireNonNull(nodeMapRefreshInterval, "nodeMapRefreshInterval is null");
    }

    @PreDestroy
    public void stop() {
        this.networkLocationCache.stop();
    }

    public Map<String, CounterStat> getTopologicalSplitCounters() {
        ImmutableMap.Builder counters = ImmutableMap.builder();
        for (int i = 0; i < this.topologicalSplitCounters.size(); ++i) {
            counters.put((Object)(i == 0 ? "all" : this.networkLocationSegmentNames.get(i - 1)), (Object)this.topologicalSplitCounters.get(i));
        }
        return counters.build();
    }

    public NodeSelector createNodeSelector(ConnectorId connectorId) {
        return this.createNodeSelector(connectorId, Integer.MAX_VALUE);
    }

    public NodeSelector createNodeSelector(ConnectorId connectorId, int maxTasksPerStage) {
        Supplier nodeMap;
        Supplier supplier = nodeMap = this.nodeMapRefreshInterval.toMillis() > 0L ? Suppliers.memoizeWithExpiration(this.createNodeMapSupplier(connectorId), (long)this.nodeMapRefreshInterval.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : this.createNodeMapSupplier(connectorId);
        if (this.useNetworkTopology) {
            return new TopologyAwareNodeSelector(this.nodeManager, this.nodeSelectionStats, this.nodeTaskMap, this.includeCoordinator, (Supplier<NodeMap>)nodeMap, this.minCandidates, this.maxSplitsPerNode, this.maxPendingSplitsPerTask, this.topologicalSplitCounters, this.networkLocationSegmentNames, this.networkLocationCache);
        }
        return new SimpleNodeSelector(this.nodeManager, this.nodeSelectionStats, this.nodeTaskMap, this.includeCoordinator, (Supplier<NodeMap>)nodeMap, this.minCandidates, this.maxSplitsPerNode, this.maxPendingSplitsPerTask, maxTasksPerStage);
    }

    private Supplier<NodeMap> createNodeMapSupplier(ConnectorId connectorId) {
        return () -> {
            ImmutableMap.Builder byNodeId = ImmutableMap.builder();
            ImmutableSetMultimap.Builder byHostAndPort = ImmutableSetMultimap.builder();
            ImmutableSetMultimap.Builder byHost = ImmutableSetMultimap.builder();
            ImmutableSetMultimap.Builder workersByNetworkPath = ImmutableSetMultimap.builder();
            Set<InternalNode> nodes = connectorId != null ? this.nodeManager.getActiveConnectorNodes(connectorId) : this.nodeManager.getNodes(NodeState.ACTIVE);
            Set coordinatorNodeIds = (Set)this.nodeManager.getCoordinators().stream().map(InternalNode::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
            for (InternalNode node : nodes) {
                byNodeId.put((Object)node.getNodeIdentifier(), (Object)node);
                if (this.useNetworkTopology && (this.includeCoordinator || !coordinatorNodeIds.contains(node.getNodeIdentifier()))) {
                    NetworkLocation location = this.networkLocationCache.get(node.getHostAndPort());
                    for (int i = 0; i <= location.getSegments().size(); ++i) {
                        workersByNetworkPath.put((Object)location.subLocation(0, i), (Object)node);
                    }
                }
                try {
                    byHostAndPort.put((Object)node.getHostAndPort(), (Object)node);
                    InetAddress host = InetAddress.getByName(node.getInternalUri().getHost());
                    byHost.put((Object)host, (Object)node);
                }
                catch (UnknownHostException unknownHostException) {}
            }
            return new NodeMap((Map<String, InternalNode>)byNodeId.build(), (SetMultimap<HostAddress, InternalNode>)byHostAndPort.build(), (SetMultimap<InetAddress, InternalNode>)byHost.build(), (SetMultimap<NetworkLocation, InternalNode>)workersByNetworkPath.build(), coordinatorNodeIds);
        };
    }

    public static List<InternalNode> selectNodes(int limit, ResettableRandomizedIterator<InternalNode> candidates) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be at least 1");
        ImmutableList.Builder selectedNodes = ImmutableList.builderWithExpectedSize((int)Math.min(limit, candidates.size()));
        for (int selectedCount = 0; selectedCount < limit && candidates.hasNext(); ++selectedCount) {
            selectedNodes.add((Object)candidates.next());
        }
        return selectedNodes.build();
    }

    public static ResettableRandomizedIterator<InternalNode> randomizedNodes(NodeMap nodeMap, boolean includeCoordinator, Set<InternalNode> excludedNodes) {
        ImmutableList nodes = (ImmutableList)nodeMap.getNodesByHostAndPort().values().stream().filter(node -> includeCoordinator || !nodeMap.getCoordinatorNodeIds().contains(node.getNodeIdentifier())).filter(node -> !excludedNodes.contains(node)).collect(ImmutableList.toImmutableList());
        return new ResettableRandomizedIterator<InternalNode>((Collection<InternalNode>)nodes);
    }

    public static List<InternalNode> selectExactNodes(NodeMap nodeMap, List<HostAddress> hosts, boolean includeCoordinator) {
        InetAddress address;
        LinkedHashSet chosen = new LinkedHashSet();
        Set<String> coordinatorIds = nodeMap.getCoordinatorNodeIds();
        for (HostAddress host : hosts) {
            nodeMap.getNodesByHostAndPort().get((Object)host).stream().filter(node -> includeCoordinator || !coordinatorIds.contains(node.getNodeIdentifier())).forEach(chosen::add);
            try {
                address = host.toInetAddress();
            }
            catch (UnknownHostException e) {
                continue;
            }
            if (host.hasPort()) continue;
            nodeMap.getNodesByHost().get((Object)address).stream().filter(node -> includeCoordinator || !coordinatorIds.contains(node.getNodeIdentifier())).forEach(chosen::add);
        }
        if (chosen.isEmpty() && !includeCoordinator) {
            for (HostAddress host : hosts) {
                nodeMap.getNodesByHostAndPort().get((Object)host).stream().forEach(chosen::add);
                try {
                    address = host.toInetAddress();
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (host.hasPort()) continue;
                nodeMap.getNodesByHost().get((Object)address).stream().forEach(chosen::add);
            }
        }
        return ImmutableList.copyOf(chosen);
    }

    public static SplitPlacementResult selectDistributionNodes(NodeMap nodeMap, NodeTaskMap nodeTaskMap, int maxSplitsPerNode, int maxPendingSplitsPerTask, Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap, NodeSelectionStats nodeSelectionStats) {
        HashMultimap assignments = HashMultimap.create();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(nodeTaskMap, nodeMap, existingTasks);
        HashSet<InternalNode> blockedNodes = new HashSet<InternalNode>();
        for (Split split : splits) {
            InternalNode node = bucketNodeMap.getAssignedNode(split).get();
            boolean isCacheable = bucketNodeMap.isSplitCacheable(split);
            if (assignmentStats.getTotalSplitCount(node) < maxSplitsPerNode || assignmentStats.getQueuedSplitCountForStage(node) < maxPendingSplitsPerTask) {
                if (isCacheable) {
                    split = new Split(split.getConnectorId(), split.getTransactionHandle(), split.getConnectorSplit(), split.getLifespan(), new SplitContext(true));
                    nodeSelectionStats.incrementBucketedPreferredNodeSelectedCount();
                } else {
                    nodeSelectionStats.incrementBucketedNonPreferredNodeSelectedCount();
                }
                assignments.put((Object)node, (Object)split);
                assignmentStats.addAssignedSplit(node);
                continue;
            }
            blockedNodes.add(node);
        }
        ListenableFuture<?> blocked = NodeScheduler.toWhenHasSplitQueueSpaceFuture(blockedNodes, existingTasks, NodeScheduler.calculateLowWatermark(maxPendingSplitsPerTask));
        return new SplitPlacementResult(blocked, (Multimap<InternalNode, Split>)ImmutableMultimap.copyOf((Multimap)assignments));
    }

    public static int calculateLowWatermark(int maxPendingSplitsPerTask) {
        return (int)Math.ceil((double)maxPendingSplitsPerTask / 2.0);
    }

    public static ListenableFuture<?> toWhenHasSplitQueueSpaceFuture(Set<InternalNode> blockedNodes, List<RemoteTask> existingTasks, int spaceThreshold) {
        if (blockedNodes.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        HashMap<String, RemoteTask> nodeToTaskMap = new HashMap<String, RemoteTask>();
        for (RemoteTask task : existingTasks) {
            nodeToTaskMap.put(task.getNodeId(), task);
        }
        List blockedFutures = (List)blockedNodes.stream().map(InternalNode::getNodeIdentifier).map(nodeToTaskMap::get).filter(Objects::nonNull).map(remoteTask -> remoteTask.whenSplitQueueHasSpace(spaceThreshold)).collect(ImmutableList.toImmutableList());
        if (blockedFutures.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        return MoreFutures.whenAnyCompleteCancelOthers((Iterable)blockedFutures);
    }

    public static ListenableFuture<?> toWhenHasSplitQueueSpaceFuture(List<RemoteTask> existingTasks, int spaceThreshold) {
        if (existingTasks.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        List stateChangeFutures = (List)existingTasks.stream().map(remoteTask -> remoteTask.whenSplitQueueHasSpace(spaceThreshold)).collect(ImmutableList.toImmutableList());
        return MoreFutures.whenAnyCompleteCancelOthers((Iterable)stateChangeFutures);
    }
}

