/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.Aggregator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class StreamingAggregationOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext systemMemoryContext;
    private final LocalMemoryContext userMemoryContext;
    private final List<Type> groupByTypes;
    private final int[] groupByChannels;
    private final List<AccumulatorFactory> accumulatorFactories;
    private final AggregationNode.Step step;
    private final PagesHashStrategy pagesHashStrategy;
    private List<Aggregator> aggregates;
    private final PageBuilder pageBuilder;
    private final Deque<Page> outputPages = new LinkedList<Page>();
    private Page currentGroup;
    private boolean finishing;

    public StreamingAggregationOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, JoinCompiler joinCompiler) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.systemMemoryContext = operatorContext.newLocalSystemMemoryContext(StreamingAggregationOperator.class.getSimpleName());
        this.userMemoryContext = operatorContext.localUserMemoryContext();
        this.groupByTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupByTypes, "groupByTypes is null"));
        this.groupByChannels = Ints.toArray((Collection)Objects.requireNonNull(groupByChannels, "groupByChannels is null"));
        this.accumulatorFactories = Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
        this.step = Objects.requireNonNull(step, "step is null");
        this.aggregates = this.setupAggregates(step, accumulatorFactories);
        this.pageBuilder = new PageBuilder(StreamingAggregationOperator.toTypes(groupByTypes, this.aggregates));
        Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        Objects.requireNonNull(sourceTypes, "sourceTypes is null");
        this.pagesHashStrategy = joinCompiler.compilePagesHashStrategyFactory(sourceTypes, groupByChannels, Optional.empty()).createPagesHashStrategy((List)sourceTypes.stream().map(type -> ImmutableList.of()).collect(ImmutableList.toImmutableList()), OptionalInt.empty());
    }

    private List<Aggregator> setupAggregates(AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AccumulatorFactory factory : accumulatorFactories) {
            builder.add((Object)new Aggregator(factory, step));
        }
        return builder.build();
    }

    private static List<Type> toTypes(List<Type> groupByTypes, List<Aggregator> aggregates) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(groupByTypes);
        aggregates.stream().map(Aggregator::getType).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputPages.isEmpty();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        this.processInput(page);
        this.updateMemoryUsage();
    }

    private void updateMemoryUsage() {
        long memorySize = this.pageBuilder.getRetainedSizeInBytes();
        for (Page output : this.outputPages) {
            memorySize += output.getRetainedSizeInBytes();
        }
        for (Aggregator aggregator : this.aggregates) {
            memorySize += aggregator.getEstimatedSize();
        }
        if (this.currentGroup != null) {
            memorySize += this.currentGroup.getRetainedSizeInBytes();
        }
        if (this.step.isOutputPartial()) {
            this.systemMemoryContext.setBytes(memorySize);
        } else {
            this.userMemoryContext.setBytes(memorySize);
        }
    }

    private void processInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Page groupByPage = page.extractChannels(this.groupByChannels);
        if (this.currentGroup != null) {
            if (!this.pagesHashStrategy.rowEqualsRow(0, this.currentGroup.extractChannels(this.groupByChannels), 0, groupByPage)) {
                this.evaluateAndFlushGroup(this.currentGroup, 0);
            }
            this.currentGroup = null;
        }
        int startPosition = 0;
        while (true) {
            int nextGroupStart = this.findNextGroupStart(startPosition, groupByPage);
            this.addRowsToAggregates(page, startPosition, nextGroupStart - 1);
            if (nextGroupStart >= page.getPositionCount()) break;
            this.evaluateAndFlushGroup(page, startPosition);
            startPosition = nextGroupStart;
        }
        this.currentGroup = page.getRegion(page.getPositionCount() - 1, 1);
    }

    private void addRowsToAggregates(Page page, int startPosition, int endPosition) {
        Page region = page.getRegion(startPosition, endPosition - startPosition + 1);
        for (Aggregator aggregator : this.aggregates) {
            aggregator.processPage(region);
        }
    }

    private void evaluateAndFlushGroup(Page page, int position) {
        this.pageBuilder.declarePosition();
        for (int i = 0; i < this.groupByTypes.size(); ++i) {
            Block block = page.getBlock(this.groupByChannels[i]);
            Type type = this.groupByTypes.get(i);
            type.appendTo(block, position, this.pageBuilder.getBlockBuilder(i));
        }
        int offset = this.groupByTypes.size();
        for (int i = 0; i < this.aggregates.size(); ++i) {
            this.aggregates.get(i).evaluate(this.pageBuilder.getBlockBuilder(offset + i));
        }
        if (this.pageBuilder.isFull()) {
            this.outputPages.add(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        this.aggregates = this.setupAggregates(this.step, this.accumulatorFactories);
    }

    private int findNextGroupStart(int startPosition, Page page) {
        for (int i = startPosition + 1; i < page.getPositionCount(); ++i) {
            if (this.pagesHashStrategy.rowEqualsRow(startPosition, page, i, page)) continue;
            return i;
        }
        return page.getPositionCount();
    }

    @Override
    public Page getOutput() {
        if (!this.outputPages.isEmpty()) {
            return this.outputPages.removeFirst();
        }
        return null;
    }

    @Override
    public void finish() {
        this.finishing = true;
        if (this.currentGroup != null) {
            this.evaluateAndFlushGroup(this.currentGroup, 0);
            this.currentGroup = null;
        }
        if (!this.pageBuilder.isEmpty()) {
            this.outputPages.add(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputPages.isEmpty() && this.currentGroup == null && this.pageBuilder.isEmpty();
    }

    public static class StreamingAggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final List<Type> groupByTypes;
        private final List<Integer> groupByChannels;
        private final AggregationNode.Step step;
        private final List<AccumulatorFactory> accumulatorFactories;
        private final JoinCompiler joinCompiler;
        private boolean closed;

        public StreamingAggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, JoinCompiler joinCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
            this.groupByTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupByTypes, "groupByTypes is null"));
            this.groupByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupByChannels, "groupByChannels is null"));
            this.step = step;
            this.accumulatorFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null"));
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, StreamingAggregationOperator.class.getSimpleName());
            return new StreamingAggregationOperator(operatorContext, this.sourceTypes, this.groupByTypes, this.groupByChannels, this.step, this.accumulatorFactories, this.joinCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new StreamingAggregationOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.groupByTypes, this.groupByChannels, this.step, this.accumulatorFactories, this.joinCompiler);
        }
    }
}

