/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.common.Page;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class PageReference {
    private final Page page;
    private final Runnable onFree;
    private final AtomicInteger referenceCount;

    public PageReference(Page page, int referenceCount, Runnable onFree) {
        this.page = Objects.requireNonNull(page, "page is null");
        this.onFree = Objects.requireNonNull(onFree, "onFree is null");
        Preconditions.checkArgument((referenceCount >= 1 ? 1 : 0) != 0, (Object)"referenceCount must be at least 1");
        this.referenceCount = new AtomicInteger(referenceCount);
    }

    public long getRetainedSizeInBytes() {
        return this.page.getRetainedSizeInBytes();
    }

    public Page removePage() {
        int referenceCount = this.referenceCount.decrementAndGet();
        Preconditions.checkArgument((referenceCount >= 0 ? 1 : 0) != 0, (Object)"Page reference count is negative");
        if (referenceCount == 0) {
            this.onFree.run();
        }
        return this.page;
    }
}

