/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.exchange.LocalExchangeMemoryManager;
import com.facebook.presto.operator.exchange.LocalExchanger;
import com.facebook.presto.operator.exchange.PageReference;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

class PartitioningExchanger
implements LocalExchanger {
    private final List<Consumer<PageReference>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final PartitionFunction partitionFunction;
    private final int[] partitioningChannels;
    private final Optional<Integer> hashChannel;
    private final IntArrayList[] partitionAssignments;

    public PartitioningExchanger(List<Consumer<PageReference>> partitions, LocalExchangeMemoryManager memoryManager, PartitionFunction partitionFunction, List<Integer> partitioningChannels, Optional<Integer> hashChannel) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitions, "partitions is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitioningChannels = Ints.toArray((Collection)Objects.requireNonNull(partitioningChannels, "partitioningChannels is null"));
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.partitionAssignments = new IntArrayList[partitions.size()];
        for (int i = 0; i < this.partitionAssignments.length; ++i) {
            this.partitionAssignments[i] = new IntArrayList();
        }
    }

    @Override
    public synchronized void accept(Page page) {
        for (IntArrayList partitionAssignment : this.partitionAssignments) {
            partitionAssignment.clear();
        }
        Page partitioningChannelsPage = this.extractPartitioningChannels(page);
        for (int position = 0; position < partitioningChannelsPage.getPositionCount(); ++position) {
            int partition = this.partitionFunction.getPartition(partitioningChannelsPage, position);
            this.partitionAssignments[partition].add(position);
        }
        for (int partition = 0; partition < this.buffers.size(); ++partition) {
            IntArrayList positions = this.partitionAssignments[partition];
            if (positions.isEmpty()) continue;
            Page pageSplit = page.copyPositions(positions.elements(), 0, positions.size());
            this.memoryManager.updateMemoryUsage(pageSplit.getRetainedSizeInBytes());
            this.buffers.get(partition).accept(new PageReference(pageSplit, 1, () -> this.memoryManager.updateMemoryUsage(-pageSplit.getRetainedSizeInBytes())));
        }
    }

    private Page extractPartitioningChannels(Page inputPage) {
        if (this.hashChannel.isPresent()) {
            return new Page(new Block[]{inputPage.getBlock(this.hashChannel.get().intValue())});
        }
        return inputPage.extractChannels(this.partitioningChannels);
    }

    @Override
    public ListenableFuture<?> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

