/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Failures;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ArrayConstructor
extends SqlScalarFunction {
    public static final ArrayConstructor ARRAY_CONSTRUCTOR = new ArrayConstructor();

    public ArrayConstructor() {
        super(new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"array_constructor"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"E")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(E)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"E"), (Object)TypeSignature.parseTypeSignature((String)"E")), true));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.HIDDEN;
    }

    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean isCalledOnNullInput() {
        return true;
    }

    public String getDescription() {
        return null;
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        MethodHandle methodHandle;
        Map<String, Type> types = boundVariables.getTypeVariables();
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)"Can only construct arrays from exactly matching types");
        ImmutableList.Builder builder = ImmutableList.builder();
        Type type = types.get("E");
        for (int i = 0; i < arity; ++i) {
            if (type.getJavaType().isPrimitive()) {
                builder.add((Object)Primitives.wrap((Class)type.getJavaType()));
                continue;
            }
            builder.add((Object)type.getJavaType());
        }
        ImmutableList stackTypes = builder.build();
        Class<?> clazz = ArrayConstructor.generateArrayConstructor(stackTypes, type);
        try {
            Method method = clazz.getMethod("arrayConstructor", (Class[])stackTypes.toArray((Object[])new Class[stackTypes.size()]));
            methodHandle = MethodHandles.lookup().unreflect(method);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return new BuiltInScalarFunctionImplementation(false, Collections.nCopies(stackTypes.size(), BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE)), methodHandle);
    }

    private static Class<?> generateArrayConstructor(List<Class<?>> stackTypes, Type elementType) {
        Failures.checkCondition(stackTypes.size() <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for array constructor", new Object[0]);
        List stackTypeNames = (List)stackTypes.stream().map(Class::getSimpleName).collect(ImmutableList.toImmutableList());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(Joiner.on((String)"").join((Iterable)stackTypeNames) + "ArrayConstructor"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < stackTypes.size(); ++i) {
            Class<?> stackType = stackTypes.get(i);
            parameters.add((Object)Parameter.arg((String)("arg" + i), stackType));
        }
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "arrayConstructor", ParameterizedType.type(Block.class), (Iterable)parameters.build());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable blockBuilderVariable = scope.declareVariable(BlockBuilder.class, "blockBuilder");
        CallSiteBinder binder = new CallSiteBinder();
        BytecodeExpression createBlockBuilder = blockBuilderVariable.set(SqlTypeBytecodeExpression.constantType(binder, elementType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)stackTypes.size())}));
        body.append((BytecodeNode)createBlockBuilder);
        for (int i = 0; i < stackTypes.size(); ++i) {
            Variable argument = scope.getVariable("arg" + i);
            IfStatement ifStatement = new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)argument, (BytecodeExpression)BytecodeExpressions.constantNull(stackTypes.get(i)))).ifTrue((BytecodeNode)blockBuilderVariable.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, elementType).writeValue((BytecodeExpression)blockBuilderVariable, argument.cast(elementType.getJavaType())));
            body.append((BytecodeNode)ifStatement);
        }
        body.append((BytecodeNode)blockBuilderVariable.invoke("build", Block.class, new BytecodeExpression[0]).ret());
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), (ClassLoader)new DynamicClassLoader(ArrayConstructor.class.getClassLoader()));
    }
}

