/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.presto.server.SimpleHttpResponseCallback;
import com.facebook.presto.server.SimpleHttpResponseHandlerStats;
import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.server.smile.JsonResponseWrapper;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.util.concurrent.FutureCallback;
import java.net.URI;
import java.util.Objects;

public class SimpleHttpResponseHandler<T>
implements FutureCallback<BaseResponse<T>> {
    private final SimpleHttpResponseCallback<T> callback;
    private final URI uri;
    private final SimpleHttpResponseHandlerStats stats;
    private final ErrorCodeSupplier errorCode;

    public SimpleHttpResponseHandler(SimpleHttpResponseCallback<T> callback, URI uri, SimpleHttpResponseHandlerStats stats, ErrorCodeSupplier errorCode) {
        this.callback = callback;
        this.uri = uri;
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
    }

    public void onSuccess(BaseResponse<T> response) {
        this.stats.updateSuccess();
        this.stats.responseSize(response.getResponseSize());
        try {
            if (response.getStatusCode() == HttpStatus.OK.code() && response.hasValue()) {
                this.callback.success(response.getValue());
            } else if (response.getStatusCode() == HttpStatus.SERVICE_UNAVAILABLE.code()) {
                this.callback.failed(new ServiceUnavailableException(this.uri));
            } else {
                Throwable cause = response.getException();
                cause = cause == null ? (response.getStatusCode() == HttpStatus.OK.code() ? new PrestoException(this.errorCode, String.format("Expected response from %s is empty", this.uri)) : new PrestoException(this.errorCode, this.createErrorMessage(response))) : new PrestoException(this.errorCode, String.format("Unexpected response from %s", this.uri), cause);
                this.callback.fatal(cause);
            }
        }
        catch (Throwable t) {
            this.callback.fatal(t);
        }
    }

    private String createErrorMessage(BaseResponse<T> response) {
        if (response instanceof JsonResponseWrapper) {
            return String.format("Expected response code from %s to be %s, but was %s: %s%n%s", this.uri, HttpStatus.OK.code(), response.getStatusCode(), response.getStatusMessage(), JsonResponseWrapper.unwrapJsonResponse(response).getResponseBody());
        }
        return String.format("Expected response code from %s to be %s, but was %s: %s", this.uri, HttpStatus.OK.code(), response.getStatusCode(), response.getStatusMessage(), new String(response.getResponseBytes()));
    }

    public void onFailure(Throwable t) {
        this.stats.updateFailure();
        this.callback.failed(t);
    }

    private static class ServiceUnavailableException
    extends RuntimeException {
        public ServiceUnavailableException(URI uri) {
            super("Server returned SERVICE_UNAVAILABLE: " + uri);
        }
    }
}

