/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.constant.Constable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class BytecodeUtils {
    private BytecodeUtils() {
    }

    public static BytecodeNode ifWasNullPopAndGoto(Scope scope, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return BytecodeUtils.handleNullValue(scope, label, returnType, ImmutableList.copyOf((Object[])stackArgsToPop), Optional.empty(), false);
    }

    public static BytecodeNode ifWasNullPopAndGoto(Scope scope, LabelNode label, Class<?> methodReturnType, Iterable<? extends Class<?>> stackArgsToPop) {
        return BytecodeUtils.handleNullValue(scope, label, methodReturnType, ImmutableList.copyOf(stackArgsToPop), Optional.empty(), false);
    }

    public static BytecodeNode ifWasNullClearPopAndGoto(Scope scope, LabelNode label, Class<?> methodReturnType, Class<?> ... stackArgsToPop) {
        return BytecodeUtils.handleNullValue(scope, label, methodReturnType, ImmutableList.copyOf((Object[])stackArgsToPop), Optional.empty(), true);
    }

    public static BytecodeNode ifWasNullClearPopAppendAndGoto(Scope scope, LabelNode label, Class<?> methodReturnType, Variable outputBlockVariable, Iterable<? extends Class<?>> stackArgsToPop) {
        return BytecodeUtils.handleNullValue(scope, label, methodReturnType, ImmutableList.copyOf(stackArgsToPop), Optional.of(outputBlockVariable), true);
    }

    public static BytecodeNode handleNullValue(Scope scope, LabelNode label, Class<?> methodReturnType, List<Class<?>> stackArgsToPop, Optional<Variable> outputBlockVariable, boolean clearNullFlag) {
        String loadDefaultOrAppendNullComment;
        if (outputBlockVariable.isPresent()) {
            Preconditions.checkArgument((methodReturnType == Void.TYPE ? 1 : 0) != 0);
        }
        Variable wasNull = scope.getVariable("wasNull");
        BytecodeBlock nullCheck = new BytecodeBlock().setDescription("ifWasNullGoto").append((BytecodeNode)wasNull);
        String clearComment = null;
        if (clearNullFlag) {
            nullCheck.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
            clearComment = "clear wasNull";
        }
        BytecodeBlock isNull = new BytecodeBlock();
        for (Class<?> parameterType : stackArgsToPop) {
            isNull.pop(parameterType);
        }
        if (!outputBlockVariable.isPresent()) {
            isNull.pushJavaDefault(methodReturnType);
            loadDefaultOrAppendNullComment = String.format("loadJavaDefault(%s)", methodReturnType.getName());
        } else {
            isNull.append((BytecodeNode)outputBlockVariable.get().invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
            loadDefaultOrAppendNullComment = "appendNullToOutputBlock";
        }
        isNull.gotoLabel(label);
        String popComment = null;
        if (!stackArgsToPop.isEmpty()) {
            popComment = String.format("pop(%s)", Joiner.on((String)", ").join(stackArgsToPop));
        }
        return new IfStatement("if wasNull then %s", new Object[]{Joiner.on((String)", ").skipNulls().join((Object)clearComment, (Object)popComment, new Object[]{loadDefaultOrAppendNullComment, "goto " + label.getLabel()})}).condition((BytecodeNode)nullCheck).ifTrue((BytecodeNode)isNull);
    }

    public static BytecodeNode boxPrimitive(Class<?> type) {
        BytecodeBlock block = new BytecodeBlock().comment("box primitive");
        if (type == Long.TYPE) {
            return block.invokeStatic(Long.class, "valueOf", Long.class, new Class[]{Long.TYPE});
        }
        if (type == Double.TYPE) {
            return block.invokeStatic(Double.class, "valueOf", Double.class, new Class[]{Double.TYPE});
        }
        if (type == Boolean.TYPE) {
            return block.invokeStatic(Boolean.class, "valueOf", Boolean.class, new Class[]{Boolean.TYPE});
        }
        if (type.isPrimitive()) {
            throw new UnsupportedOperationException("not yet implemented: " + type);
        }
        return OpCode.NOP;
    }

    public static BytecodeNode unboxPrimitive(Class<?> unboxedType) {
        BytecodeBlock block = new BytecodeBlock().comment("unbox primitive");
        if (unboxedType == Long.TYPE) {
            return block.invokeVirtual(Long.class, "longValue", Long.TYPE, new Class[0]);
        }
        if (unboxedType == Double.TYPE) {
            return block.invokeVirtual(Double.class, "doubleValue", Double.TYPE, new Class[0]);
        }
        if (unboxedType == Boolean.TYPE) {
            return block.invokeVirtual(Boolean.class, "booleanValue", Boolean.TYPE, new Class[0]);
        }
        throw new UnsupportedOperationException("not yet implemented: " + unboxedType);
    }

    public static BytecodeExpression loadConstant(CallSiteBinder callSiteBinder, Object constant, Class<?> type) {
        Binding binding = callSiteBinder.bind(MethodHandles.constant(type, constant));
        return BytecodeUtils.loadConstant(binding);
    }

    public static BytecodeExpression loadConstant(Binding binding) {
        return BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)binding.getBindingId()), (String)("constant_" + binding.getBindingId()), (Class)binding.getType().returnType(), (BytecodeExpression[])new BytecodeExpression[0]);
    }

    public static BytecodeNode generateInvocation(Scope scope, String name, BuiltInScalarFunctionImplementation function, Optional<BytecodeNode> instance, List<BytecodeNode> arguments, CallSiteBinder binder) {
        return BytecodeUtils.generateInvocation(scope, name, function, instance, arguments, binder, Optional.empty());
    }

    public static BytecodeNode generateInvocation(Scope scope, String name, BuiltInScalarFunctionImplementation function, Optional<BytecodeNode> instance, List<BytecodeNode> arguments, CallSiteBinder binder, Optional<OutputBlockVariableAndType> outputBlockVariableAndType) {
        LabelNode end = new LabelNode("end");
        BytecodeBlock block = new BytecodeBlock().setDescription("invoke " + name);
        ArrayList stackTypes = new ArrayList();
        if (function.getInstanceFactory().isPresent()) {
            Preconditions.checkArgument((boolean)instance.isPresent());
        }
        int currentParameterIndex = 0;
        int realParameterIndex = 0;
        List<BuiltInScalarFunctionImplementation.ScalarImplementationChoice> choices = function.getAllChoices();
        BuiltInScalarFunctionImplementation.ScalarImplementationChoice bestChoice = null;
        for (BuiltInScalarFunctionImplementation.ScalarImplementationChoice currentChoice : choices) {
            boolean isValid = true;
            for (int i = 0; i < arguments.size(); ++i) {
                if (currentChoice.getArgumentProperty(i).getArgumentType() != BuiltInScalarFunctionImplementation.ArgumentType.VALUE_TYPE || (currentChoice.getArgumentProperty(i).getNullConvention() != BuiltInScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION || arguments.get(i) instanceof InputReferenceCompiler.InputReferenceNode) && (currentChoice.getReturnPlaceConvention() != BuiltInScalarFunctionImplementation.ReturnPlaceConvention.PROVIDED_BLOCKBUILDER || outputBlockVariableAndType.isPresent())) continue;
                isValid = false;
                break;
            }
            if (!isValid) continue;
            bestChoice = currentChoice;
        }
        Preconditions.checkState((bestChoice != null ? 1 : 0) != 0, (Object)"None of the scalar function implementation choices are valid");
        Binding binding = binder.bind(bestChoice.getMethodHandle());
        MethodType methodType = binding.getType();
        TypeDescriptor.OfField returnType = methodType.returnType();
        Class unboxedReturnType = Primitives.unwrap((Class)returnType);
        boolean boundInstance = false;
        while (currentParameterIndex < methodType.parameterArray().length) {
            Class<?> type = methodType.parameterArray()[currentParameterIndex];
            stackTypes.add(type);
            if (bestChoice.getInstanceFactory().isPresent() && !boundInstance) {
                Preconditions.checkState((boolean)type.equals(bestChoice.getInstanceFactory().get().type().returnType()), (Object)"Mismatched type for instance parameter");
                block.append(instance.get());
                boundInstance = true;
            } else if (type == SqlFunctionProperties.class) {
                block.append((BytecodeNode)scope.getVariable("properties"));
            } else if (type == BlockBuilder.class) {
                block.append((BytecodeNode)outputBlockVariableAndType.get().getOutputBlockVariable());
            } else {
                BuiltInScalarFunctionImplementation.ArgumentProperty argumentProperty = bestChoice.getArgumentProperty(realParameterIndex);
                block0 : switch (argumentProperty.getArgumentType()) {
                    case VALUE_TYPE: {
                        switch (argumentProperty.getNullConvention()) {
                            case RETURN_NULL_ON_NULL: {
                                block.append(arguments.get(realParameterIndex));
                                Preconditions.checkArgument((!Primitives.isWrapperType(type) ? 1 : 0) != 0, (Object)"Non-nullable argument must not be primitive wrapper type");
                                switch (bestChoice.getReturnPlaceConvention()) {
                                    case STACK: {
                                        block.append(BytecodeUtils.ifWasNullPopAndGoto(scope, end, unboxedReturnType, Lists.reverse(stackTypes)));
                                        break block0;
                                    }
                                    case PROVIDED_BLOCKBUILDER: {
                                        Preconditions.checkArgument((unboxedReturnType == Void.TYPE ? 1 : 0) != 0);
                                        block.append(BytecodeUtils.ifWasNullClearPopAppendAndGoto(scope, end, unboxedReturnType, outputBlockVariableAndType.get().getOutputBlockVariable(), Lists.reverse(stackTypes)));
                                        break block0;
                                    }
                                }
                                throw new UnsupportedOperationException(String.format("Unsupported return place convention: %s", new Object[]{bestChoice.getReturnPlaceConvention()}));
                            }
                            case USE_NULL_FLAG: {
                                block.append(arguments.get(realParameterIndex));
                                block.append((BytecodeNode)scope.getVariable("wasNull"));
                                block.append((BytecodeNode)scope.getVariable("wasNull").set(BytecodeExpressions.constantFalse()));
                                stackTypes.add(Boolean.TYPE);
                                ++currentParameterIndex;
                                break block0;
                            }
                            case USE_BOXED_TYPE: {
                                block.append(arguments.get(realParameterIndex));
                                block.append(BytecodeUtils.boxPrimitiveIfNecessary(scope, type));
                                block.append((BytecodeNode)scope.getVariable("wasNull").set(BytecodeExpressions.constantFalse()));
                                break block0;
                            }
                            case BLOCK_AND_POSITION: {
                                InputReferenceCompiler.InputReferenceNode inputReferenceNode = (InputReferenceCompiler.InputReferenceNode)arguments.get(realParameterIndex);
                                block.append(inputReferenceNode.produceBlockAndPosition());
                                stackTypes.add(Integer.TYPE);
                                ++currentParameterIndex;
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException(String.format("Unsupported null convention: %s", new Object[]{argumentProperty.getNullConvention()}));
                    }
                    case FUNCTION_TYPE: {
                        block.append(arguments.get(realParameterIndex));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported argument type: %s", new Object[]{argumentProperty.getArgumentType()}));
                    }
                }
                ++realParameterIndex;
            }
            ++currentParameterIndex;
        }
        block.append((BytecodeNode)BytecodeUtils.invoke(binding, name));
        if (function.isNullable()) {
            switch (bestChoice.getReturnPlaceConvention()) {
                case STACK: {
                    block.append((BytecodeNode)BytecodeUtils.unboxPrimitiveIfNecessary(scope, returnType));
                    break;
                }
                case PROVIDED_BLOCKBUILDER: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported return place convention: %s", new Object[]{bestChoice.getReturnPlaceConvention()}));
                }
            }
        }
        block.visitLabel(end);
        if (outputBlockVariableAndType.isPresent()) {
            switch (bestChoice.getReturnPlaceConvention()) {
                case STACK: {
                    block.append(BytecodeUtils.generateWrite(binder, scope, scope.getVariable("wasNull"), outputBlockVariableAndType.get().getType(), outputBlockVariableAndType.get().getOutputBlockVariable()));
                    break;
                }
                case PROVIDED_BLOCKBUILDER: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported return place convention: %s", new Object[]{bestChoice.getReturnPlaceConvention()}));
                }
            }
        }
        return block;
    }

    public static BytecodeBlock unboxPrimitiveIfNecessary(Scope scope, Class<?> boxedType) {
        BytecodeBlock block = new BytecodeBlock();
        LabelNode end = new LabelNode("end");
        Class unboxedType = Primitives.unwrap(boxedType);
        Variable wasNull = scope.getVariable("wasNull");
        if (unboxedType.isPrimitive()) {
            LabelNode notNull = new LabelNode("notNull");
            block.dup(boxedType).ifNotNullGoto(notNull).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantTrue())).comment("swap boxed null with unboxed default").pop(boxedType).pushJavaDefault(unboxedType).gotoLabel(end).visitLabel(notNull).append(BytecodeUtils.unboxPrimitive(unboxedType));
        } else {
            block.dup(boxedType).ifNotNullGoto(end).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantTrue()));
        }
        block.visitLabel(end);
        return block;
    }

    public static BytecodeNode boxPrimitiveIfNecessary(Scope scope, Class<?> type) {
        Class<Constable> expectedCurrentStackType;
        Preconditions.checkArgument((!type.isPrimitive() ? 1 : 0) != 0, (Object)"cannot box into primitive type");
        if (!Primitives.isWrapperType(type)) {
            return OpCode.NOP;
        }
        BytecodeBlock notNull = new BytecodeBlock().comment("box primitive");
        if (type == Long.class) {
            notNull.invokeStatic(Long.class, "valueOf", Long.class, new Class[]{Long.TYPE});
            expectedCurrentStackType = Long.TYPE;
        } else if (type == Double.class) {
            notNull.invokeStatic(Double.class, "valueOf", Double.class, new Class[]{Double.TYPE});
            expectedCurrentStackType = Double.TYPE;
        } else if (type == Boolean.class) {
            notNull.invokeStatic(Boolean.class, "valueOf", Boolean.class, new Class[]{Boolean.TYPE});
            expectedCurrentStackType = Boolean.TYPE;
        } else {
            throw new UnsupportedOperationException("not yet implemented: " + type);
        }
        BytecodeBlock condition = new BytecodeBlock().append((BytecodeNode)scope.getVariable("wasNull"));
        BytecodeBlock wasNull = new BytecodeBlock().pop(expectedCurrentStackType).pushNull().checkCast(type);
        return new IfStatement().condition((BytecodeNode)condition).ifTrue((BytecodeNode)wasNull).ifFalse((BytecodeNode)notNull);
    }

    public static BytecodeExpression invoke(Binding binding, String name) {
        return BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)binding.getBindingId()), (String)name, (MethodType)binding.getType(), (BytecodeExpression[])new BytecodeExpression[0]);
    }

    public static BytecodeNode generateWrite(CallSiteBinder callSiteBinder, Scope scope, Variable wasNullVariable, Type type, Variable outputBlockVariable) {
        Class<Object> valueJavaType = type.getJavaType();
        if (!valueJavaType.isPrimitive() && valueJavaType != Slice.class) {
            valueJavaType = Object.class;
        }
        String methodName = "write" + Primitives.wrap(valueJavaType).getSimpleName();
        Variable tempValue = scope.createTempVariable(valueJavaType);
        return new BytecodeBlock().comment("if (wasNull)").append((BytecodeNode)new IfStatement().condition((BytecodeNode)wasNullVariable).ifTrue((BytecodeNode)new BytecodeBlock().comment("output.appendNull();").pop(valueJavaType).getVariable(outputBlockVariable).invokeInterface(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop()).ifFalse((BytecodeNode)new BytecodeBlock().comment("%s.%s(output, %s)", new Object[]{type.getTypeSignature(), methodName, valueJavaType.getSimpleName()}).putVariable(tempValue).append((BytecodeNode)BytecodeUtils.loadConstant(callSiteBinder.bind(type, Type.class))).getVariable(outputBlockVariable).getVariable(tempValue).invokeInterface(Type.class, methodName, Void.TYPE, new Class[]{BlockBuilder.class, valueJavaType})));
    }

    public static class OutputBlockVariableAndType {
        private final Variable outputBlockVariable;
        private final Type type;

        public OutputBlockVariableAndType(Variable outputBlockVariable, Type type) {
            this.outputBlockVariable = Objects.requireNonNull(outputBlockVariable);
            this.type = Objects.requireNonNull(type);
        }

        public Variable getOutputBlockVariable() {
            return this.outputBlockVariable;
        }

        public Type getType() {
            return this.type;
        }
    }
}

