/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CanonicalPartitioningScheme {
    private final Optional<ConnectorId> connectorId;
    private final ConnectorPartitioningHandle connectorHandle;
    private final List<RowExpression> arguments;
    private final List<VariableReferenceExpression> outputLayout;

    public static CanonicalPartitioningScheme getCanonicalPartitioningScheme(PartitioningScheme partitioningScheme, Map<VariableReferenceExpression, VariableReferenceExpression> originalToNewVariableNames) {
        return new CanonicalPartitioningScheme(partitioningScheme.getPartitioning().getHandle().getConnectorId(), partitioningScheme.getPartitioning().getHandle().getConnectorHandle(), (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> RowExpressionVariableInliner.inlineVariables(originalToNewVariableNames, argument)).collect(ImmutableList.toImmutableList()), (List)partitioningScheme.getOutputLayout().stream().map(originalToNewVariableNames::get).collect(ImmutableList.toImmutableList()));
    }

    private CanonicalPartitioningScheme(Optional<ConnectorId> connectorId, ConnectorPartitioningHandle connectorHandle, List<RowExpression> arguments, List<VariableReferenceExpression> outputLayout) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
        this.outputLayout = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputLayout, "outputLayout is null"));
    }

    public Optional<ConnectorId> getConnectorId() {
        return this.connectorId;
    }

    public ConnectorPartitioningHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    public List<RowExpression> getArguments() {
        return this.arguments;
    }

    public List<VariableReferenceExpression> getOutputLayout() {
        return this.outputLayout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalPartitioningScheme that = (CanonicalPartitioningScheme)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.connectorHandle, that.connectorHandle) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.outputLayout, that.outputLayout);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.connectorHandle, this.arguments, this.outputLayout);
    }
}

