/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CanonicalTableScanNode
extends PlanNode {
    private final CanonicalTableHandle table;
    private final Map<VariableReferenceExpression, ColumnHandle> assignments;
    private final List<VariableReferenceExpression> outputVariables;

    public CanonicalTableScanNode(PlanNodeId id, CanonicalTableHandle table, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputVariables = Collections.unmodifiableList(Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = Collections.unmodifiableMap(new HashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputVariables), (Object)"assignments does not cover all of outputs");
    }

    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }

    public CanonicalTableHandle getTable() {
        return this.table;
    }

    public Map<VariableReferenceExpression, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CanonicalTableScanNode that = (CanonicalTableScanNode)((Object)o);
        return Objects.equals(this.table, that.table) && Objects.equals(this.assignments, that.assignments) && Objects.equals(this.outputVariables, that.outputVariables);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.assignments, this.outputVariables);
    }

    public static class CanonicalTableHandle {
        private final ConnectorId connectorId;
        private final ConnectorTableHandle connectorHandle;
        private final Optional<Object> layoutIdentifier;

        public static CanonicalTableHandle getCanonicalTableHandle(TableHandle tableHandle) {
            return new CanonicalTableHandle(tableHandle.getConnectorId(), tableHandle.getConnectorHandle(), tableHandle.getLayout());
        }

        private CanonicalTableHandle(ConnectorId connectorId, ConnectorTableHandle connectorHandle, Optional<ConnectorTableLayoutHandle> layout) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
            this.layoutIdentifier = Objects.requireNonNull(layout, "layout is null").map(ConnectorTableLayoutHandle::getIdentifier);
        }

        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        public ConnectorTableHandle getConnectorHandle() {
            return this.connectorHandle;
        }

        public Optional<Object> getLayoutIdentifier() {
            return this.layoutIdentifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CanonicalTableHandle that = (CanonicalTableHandle)o;
            return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.connectorHandle, that.connectorHandle) && Objects.equals(this.layoutIdentifier, that.layoutIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.connectorHandle, this.layoutIdentifier);
        }
    }
}

