/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.google.common.base.Preconditions;

public final class ApplyNodeUtil {
    private ApplyNodeUtil() {
    }

    public static void verifySubquerySupported(Assignments assignments) {
        Preconditions.checkArgument((boolean)assignments.getExpressions().stream().map(OriginalExpressionUtils::castToExpression).allMatch(ApplyNodeUtil::isSupportedSubqueryExpression), (Object)"Unexpected expression used for subquery expression");
    }

    public static boolean isSupportedSubqueryExpression(Expression expression) {
        return expression instanceof InPredicate || expression instanceof ExistsPredicate || expression instanceof QuantifiedComparisonExpression;
    }
}

