/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.type.LikePatternType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class FunctionResolution
implements StandardFunctionResolution {
    private final FunctionAndTypeManager functionAndTypeManager;

    public FunctionResolution(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    public FunctionHandle notFunction() {
        return this.functionAndTypeManager.lookupFunction("not", TypeSignatureProvider.fromTypes(new Type[]{BooleanType.BOOLEAN}));
    }

    public boolean isNotFunction(FunctionHandle functionHandle) {
        return this.notFunction().equals(functionHandle);
    }

    public FunctionHandle likeVarcharFunction() {
        return this.functionAndTypeManager.lookupFunction("LIKE", TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN}));
    }

    public FunctionHandle likeCharFunction(Type valueType) {
        Preconditions.checkArgument((boolean)(valueType instanceof CharType), (Object)"Expected CHAR value type");
        return this.functionAndTypeManager.lookupFunction("LIKE", TypeSignatureProvider.fromTypes(new Type[]{valueType, LikePatternType.LIKE_PATTERN}));
    }

    public boolean isLikeFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getName().equals((Object)QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"LIKE"));
    }

    public FunctionHandle likePatternFunction() {
        return this.functionAndTypeManager.lookupFunction("LIKE_PATTERN", TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
    }

    public boolean isCastFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getOperatorType().equals(Optional.of(OperatorType.CAST));
    }

    public boolean isTryCastFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getName().equals((Object)QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"TRY_CAST"));
    }

    public boolean isArrayConstructor(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getName().equals((Object)QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"array_constructor"));
    }

    public FunctionHandle betweenFunction(Type valueType, Type lowerBoundType, Type upperBoundType) {
        return this.functionAndTypeManager.lookupFunction(OperatorType.BETWEEN.getFunctionName().getFunctionName(), TypeSignatureProvider.fromTypes(valueType, lowerBoundType, upperBoundType));
    }

    public boolean isBetweenFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getOperatorType().equals(Optional.of(OperatorType.BETWEEN));
    }

    public FunctionHandle arithmeticFunction(OperatorType operator, Type leftType, Type rightType) {
        Preconditions.checkArgument((boolean)operator.isArithmeticOperator(), (Object)String.format("unexpected arithmetic type %s", operator));
        return this.functionAndTypeManager.resolveOperator(operator, TypeSignatureProvider.fromTypes(leftType, rightType));
    }

    public FunctionHandle arithmeticFunction(ArithmeticBinaryExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case ADD: {
                operatorType = OperatorType.ADD;
                break;
            }
            case SUBTRACT: {
                operatorType = OperatorType.SUBTRACT;
                break;
            }
            case MULTIPLY: {
                operatorType = OperatorType.MULTIPLY;
                break;
            }
            case DIVIDE: {
                operatorType = OperatorType.DIVIDE;
                break;
            }
            case MODULUS: {
                operatorType = OperatorType.MODULUS;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown arithmetic operator: " + operator);
            }
        }
        return this.arithmeticFunction(operatorType, leftType, rightType);
    }

    public boolean isArithmeticFunction(FunctionHandle functionHandle) {
        Optional operatorType = this.functionAndTypeManager.getFunctionMetadata(functionHandle).getOperatorType();
        return operatorType.isPresent() && ((OperatorType)operatorType.get()).isArithmeticOperator();
    }

    public FunctionHandle negateFunction(Type type) {
        return this.functionAndTypeManager.lookupFunction(OperatorType.NEGATION.getFunctionName().getFunctionName(), TypeSignatureProvider.fromTypes(type));
    }

    public boolean isNegateFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getOperatorType().equals(Optional.of(OperatorType.NEGATION));
    }

    public FunctionHandle arrayConstructor(List<? extends Type> argumentTypes) {
        return this.functionAndTypeManager.lookupFunction("array_constructor", TypeSignatureProvider.fromTypes(argumentTypes));
    }

    public FunctionHandle comparisonFunction(OperatorType operator, Type leftType, Type rightType) {
        Preconditions.checkArgument((boolean)operator.isComparisonOperator(), (Object)String.format("unexpected comparison type %s", operator));
        return this.functionAndTypeManager.resolveOperator(operator, TypeSignatureProvider.fromTypes(leftType, rightType));
    }

    public FunctionHandle comparisonFunction(ComparisonExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case EQUAL: {
                operatorType = OperatorType.EQUAL;
                break;
            }
            case NOT_EQUAL: {
                operatorType = OperatorType.NOT_EQUAL;
                break;
            }
            case LESS_THAN: {
                operatorType = OperatorType.LESS_THAN;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                operatorType = OperatorType.LESS_THAN_OR_EQUAL;
                break;
            }
            case GREATER_THAN: {
                operatorType = OperatorType.GREATER_THAN;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                operatorType = OperatorType.GREATER_THAN_OR_EQUAL;
                break;
            }
            case IS_DISTINCT_FROM: {
                operatorType = OperatorType.IS_DISTINCT_FROM;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported comparison operator type: " + operator);
            }
        }
        return this.comparisonFunction(operatorType, leftType, rightType);
    }

    public boolean isComparisonFunction(FunctionHandle functionHandle) {
        Optional operatorType = this.functionAndTypeManager.getFunctionMetadata(functionHandle).getOperatorType();
        return operatorType.isPresent() && ((OperatorType)operatorType.get()).isComparisonOperator();
    }

    public FunctionHandle subscriptFunction(Type baseType, Type indexType) {
        return this.functionAndTypeManager.lookupFunction(OperatorType.SUBSCRIPT.getFunctionName().getFunctionName(), TypeSignatureProvider.fromTypes(baseType, indexType));
    }

    public boolean isSubscriptFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getOperatorType().equals(Optional.of(OperatorType.SUBSCRIPT));
    }

    public FunctionHandle tryFunction(Type returnType) {
        return this.functionAndTypeManager.lookupFunction("$internal$try", TypeSignatureProvider.fromTypes(returnType));
    }

    public boolean isTryFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getName().equals((Object)"$internal$try");
    }

    public boolean isFailFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getName().equals((Object)QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"fail"));
    }

    public boolean isCountFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getName().equals((Object)QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"count"));
    }

    public FunctionHandle countFunction() {
        return this.functionAndTypeManager.lookupFunction("count", (List<TypeSignatureProvider>)ImmutableList.of());
    }

    public FunctionHandle countFunction(Type valueType) {
        return this.functionAndTypeManager.lookupFunction("count", TypeSignatureProvider.fromTypes(valueType));
    }

    public boolean isMaxFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getName().equals((Object)QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"max"));
    }

    public FunctionHandle maxFunction(Type valueType) {
        return this.functionAndTypeManager.lookupFunction("max", TypeSignatureProvider.fromTypes(valueType));
    }

    public boolean isMinFunction(FunctionHandle functionHandle) {
        return this.functionAndTypeManager.getFunctionMetadata(functionHandle).getName().equals((Object)QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"min"));
    }

    public FunctionHandle minFunction(Type valueType) {
        return this.functionAndTypeManager.lookupFunction("min", TypeSignatureProvider.fromTypes(valueType));
    }
}

