/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.InvalidFunctionArgumentException;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.List;

public class DecimalParametricType
implements ParametricType {
    public static final DecimalParametricType DECIMAL = new DecimalParametricType();

    public String getName() {
        return "decimal";
    }

    public Type createType(List<TypeParameter> parameters) {
        try {
            switch (parameters.size()) {
                case 0: {
                    return DecimalType.createDecimalType();
                }
                case 1: {
                    return DecimalType.createDecimalType((int)parameters.get(0).getLongLiteral().intValue());
                }
                case 2: {
                    return DecimalType.createDecimalType((int)parameters.get(0).getLongLiteral().intValue(), (int)parameters.get(1).getLongLiteral().intValue());
                }
            }
            throw new IllegalArgumentException("Expected 0, 1 or 2 parameters for DECIMAL type constructor.");
        }
        catch (InvalidFunctionArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, e.getMessage(), (Throwable)e);
        }
    }
}

