/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.plugin.jdbc.optimization.JdbcExpression;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class JdbcSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final Optional<JdbcExpression> additionalPredicate;

    @JsonCreator
    public JdbcSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="catalogName") @Nullable String catalogName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain, @JsonProperty(value="additionalProperty") Optional<JdbcExpression> additionalPredicate) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = Objects.requireNonNull(tableName, "table name is null");
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        this.additionalPredicate = Objects.requireNonNull(additionalPredicate, "additionalPredicate is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    @JsonProperty
    public Optional<JdbcExpression> getAdditionalPredicate() {
        return this.additionalPredicate;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }
}

