/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.verifier.checksum.ArrayColumnValidator;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.checksum.MapColumnChecksum;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MapColumnValidator
implements ColumnValidator {
    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        Preconditions.checkArgument((boolean)(column.getType() instanceof MapType), (String)"Expect MapType, found %s", (Object)column.getType().getDisplayName());
        Type keyType = ((MapType)column.getType()).getKeyType();
        Type valueType = ((MapType)column.getType()).getValueType();
        Expression checksum = QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{column.getExpression()});
        Expression keysChecksum = ArrayColumnValidator.generateArrayChecksum(QueryUtil.functionCall((String)"map_keys", (Expression[])new Expression[]{column.getExpression()}), (Type)new ArrayType(keyType));
        Expression valuesChecksum = ArrayColumnValidator.generateArrayChecksum(QueryUtil.functionCall((String)"map_values", (Expression[])new Expression[]{column.getExpression()}), (Type)new ArrayType(valueType));
        Expression mapCardinalityChecksum = QueryUtil.functionCall((String)"checksum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})});
        CoalesceExpression mapCardinalitySum = new CoalesceExpression(QueryUtil.functionCall((String)"sum", (Expression[])new Expression[]{QueryUtil.functionCall((String)"cardinality", (Expression[])new Expression[]{column.getExpression()})}), (Expression)new LongLiteral("0"), new Expression[0]);
        return ImmutableList.of((Object)new SingleColumn(checksum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getChecksumColumnAlias(column)))), (Object)new SingleColumn(keysChecksum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getKeysChecksumColumnAlias(column)))), (Object)new SingleColumn(valuesChecksum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getValuesChecksumColumnAlias(column)))), (Object)new SingleColumn(mapCardinalityChecksum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getCardinalityChecksumColumnAlias(column)))), (Object)new SingleColumn((Expression)mapCardinalitySum, Optional.of(VerifierUtil.delimitedIdentifier(MapColumnValidator.getCardinalitySumColumnAlias(column)))));
    }

    public List<ColumnMatchResult<MapColumnChecksum>> validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        MapColumnChecksum controlChecksum = MapColumnValidator.toColumnChecksum(column, controlResult);
        MapColumnChecksum testChecksum = MapColumnValidator.toColumnChecksum(column, testResult);
        return ImmutableList.of(new ColumnMatchResult<MapColumnChecksum>(Objects.equals(controlChecksum, testChecksum), column, controlChecksum, testChecksum));
    }

    private static MapColumnChecksum toColumnChecksum(Column column, ChecksumResult checksumResult) {
        return new MapColumnChecksum(checksumResult.getChecksum(MapColumnValidator.getChecksumColumnAlias(column)), checksumResult.getChecksum(MapColumnValidator.getKeysChecksumColumnAlias(column)), checksumResult.getChecksum(MapColumnValidator.getValuesChecksumColumnAlias(column)), checksumResult.getChecksum(MapColumnValidator.getCardinalityChecksumColumnAlias(column)), (Long)checksumResult.getChecksum(MapColumnValidator.getCardinalitySumColumnAlias(column)));
    }

    private static String getChecksumColumnAlias(Column column) {
        return column.getName() + "$checksum";
    }

    private static String getKeysChecksumColumnAlias(Column column) {
        return column.getName() + "$keys_checksum";
    }

    private static String getValuesChecksumColumnAlias(Column column) {
        return column.getName() + "$values_checksum";
    }

    private static String getCardinalityChecksumColumnAlias(Column column) {
        return column.getName() + "$cardinality_checksum";
    }

    private static String getCardinalitySumColumnAlias(Column column) {
        return column.getName() + "$cardinality_sum";
    }
}

