/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.verifier.event.EventClientModule;
import com.facebook.presto.verifier.framework.VerifierModule;
import com.facebook.presto.verifier.framework.VerifyCommand;
import com.facebook.presto.verifier.prestoaction.QueryActionsModule;
import com.facebook.presto.verifier.source.SourceQueryModule;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import io.airlift.airline.Arguments;

public abstract class AbstractVerifyCommand
implements VerifyCommand {
    private static final Logger log = Logger.get(AbstractVerifyCommand.class);
    @Arguments(description="Config filename")
    public String configFilename;

    @Override
    public void run() {
        if (this.configFilename != null) {
            System.setProperty("config", this.configFilename);
        }
        Bootstrap app = new Bootstrap((Iterable)ImmutableList.builder().add((Object)new VerifierModule(this.getSqlParserOptions(), this.getCustomQueryFilterClasses())).add((Object)new SourceQueryModule(this.getCustomSourceQuerySupplierTypes())).add((Object)new EventClientModule(this.getCustomEventClientTypes())).add((Object)new QueryActionsModule(this.getSqlExceptionClassifier(), this.getCustomQueryActionTypes())).addAll(this.getAdditionalModules()).build());
        Injector injector = null;
        try {
            injector = app.strictConfig().initialize();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (injector != null) {
                try {
                    ((LifeCycleManager)injector.getInstance(LifeCycleManager.class)).stop();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }
}

