/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import java.util.Objects;

public enum DeterminismAnalysis {
    DETERMINISTIC(Category.DETERMINISTIC),
    NON_DETERMINISTIC_COLUMNS(Category.NON_DETERMINISTIC),
    NON_DETERMINISTIC_ROW_COUNT(Category.NON_DETERMINISTIC),
    NON_DETERMINISTIC_LIMIT_CLAUSE(Category.NON_DETERMINISTIC),
    NON_DETERMINISTIC_CATALOG(Category.NON_DETERMINISTIC),
    ANALYSIS_FAILED_INCONSISTENT_SCHEMA(Category.UNKNOWN),
    ANALYSIS_FAILED_QUERY_FAILURE(Category.UNKNOWN),
    ANALYSIS_FAILED_DATA_CHANGED(Category.UNKNOWN),
    ANALYSIS_FAILED(Category.UNKNOWN);

    private final Category category;

    private DeterminismAnalysis(Category category) {
        this.category = Objects.requireNonNull(category, "category is null");
    }

    public boolean isDeterministic() {
        return this.category == Category.DETERMINISTIC;
    }

    public boolean isNonDeterministic() {
        return this.category == Category.NON_DETERMINISTIC;
    }

    public boolean isUnknown() {
        return this.category == Category.UNKNOWN;
    }

    private static enum Category {
        DETERMINISTIC,
        NON_DETERMINISTIC,
        UNKNOWN;

    }
}

