/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.LegacyConfig;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class DeterminismAnalyzerConfig {
    private boolean runTeardown;
    private int maxAnalysisRuns = 2;
    private boolean handleLimitQuery = true;
    private Set<String> nonDeterministicCatalogs = ImmutableSet.of();

    public boolean isRunTeardown() {
        return this.runTeardown;
    }

    @ConfigDescription(value="When set to false, temporary tables are not dropped for determinism analysis runs")
    @Config(value="determinism.run-teardown")
    @LegacyConfig(value={"run-teardown-for-determinism-analysis"})
    public DeterminismAnalyzerConfig setRunTeardown(boolean runTeardown) {
        this.runTeardown = runTeardown;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxAnalysisRuns() {
        return this.maxAnalysisRuns;
    }

    @Config(value="determinism.max-analysis-runs")
    @LegacyConfig(value={"max-determinism-analysis-runs"})
    public DeterminismAnalyzerConfig setMaxAnalysisRuns(int maxAnalysisRuns) {
        this.maxAnalysisRuns = maxAnalysisRuns;
        return this;
    }

    public boolean isHandleLimitQuery() {
        return this.handleLimitQuery;
    }

    @Config(value="determinism.handle-limit-query")
    @LegacyConfig(value={"enable-limit-query-determinism-analyzer"})
    public DeterminismAnalyzerConfig setHandleLimitQuery(boolean handleLimitQuery) {
        this.handleLimitQuery = handleLimitQuery;
        return this;
    }

    @NotNull
    public Set<String> getNonDeterministicCatalogs() {
        return this.nonDeterministicCatalogs;
    }

    @Config(value="determinism.non-deterministic-catalogs")
    @ConfigDescription(value="A comma-separated list of non-deterministic catalogs. Queries referencing table from those catalogs are treated as non-deterministic.")
    public DeterminismAnalyzerConfig setNonDeterministicCatalogs(String nonDeterministicCatalogs) {
        if (nonDeterministicCatalogs != null) {
            this.nonDeterministicCatalogs = (Set)Splitter.on((String)",").trimResults().splitToList((CharSequence)nonDeterministicCatalogs).stream().map(catalog -> catalog.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        }
        return this;
    }
}

