/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.planPrinter.JsonRenderer;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.event.DeterminismAnalysisDetails;
import com.facebook.presto.verifier.event.QueryInfo;
import com.facebook.presto.verifier.framework.AbstractVerification;
import com.facebook.presto.verifier.framework.ChecksumQueryContext;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.ExplainMatchResult;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.QueryActions;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExplainVerification
extends AbstractVerification<QueryBundle, ExplainMatchResult, String> {
    private static final PrestoAction.ResultSetConverter<String> QUERY_PLAN_RESULT_SET_CONVERTER = resultSet -> Optional.of(resultSet.getString("Query Plan"));
    private static final JsonCodec<JsonRenderer.JsonRenderedNode> PLAN_CODEC = JsonCodec.jsonCodec(JsonRenderer.JsonRenderedNode.class);
    private final SqlParser sqlParser;

    public ExplainVerification(QueryActions queryActions, SourceQuery sourceQuery, SqlExceptionClassifier exceptionClassifier, VerificationContext verificationContext, VerifierConfig verifierConfig, SqlParser sqlParser) {
        super(queryActions, sourceQuery, exceptionClassifier, verificationContext, Optional.of(QUERY_PLAN_RESULT_SET_CONVERTER), verifierConfig);
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    protected QueryBundle getQueryRewrite(ClusterType clusterType) {
        Statement statement = this.sqlParser.createStatement(this.getSourceQuery().getQuery(clusterType), VerifierUtil.PARSING_OPTIONS);
        Explain explain = new Explain(statement, false, false, (List)ImmutableList.of((Object)new ExplainFormat(ExplainFormat.Type.JSON)));
        return new QueryBundle((List<Statement>)ImmutableList.of(), (Statement)explain, (List<Statement>)ImmutableList.of(), clusterType);
    }

    @Override
    protected ExplainMatchResult verify(QueryBundle control, QueryBundle test, Optional<QueryResult<String>> controlQueryResult, Optional<QueryResult<String>> testQueryResult, ChecksumQueryContext controlContext, ChecksumQueryContext testContext) {
        Preconditions.checkArgument((boolean)controlQueryResult.isPresent(), (Object)"control query plan is missing");
        Preconditions.checkArgument((boolean)testQueryResult.isPresent(), (Object)"test query plan is missing");
        JsonRenderer.JsonRenderedNode controlPlan = (JsonRenderer.JsonRenderedNode)PLAN_CODEC.fromJson((String)Iterables.getOnlyElement(controlQueryResult.get().getResults()));
        JsonRenderer.JsonRenderedNode testPlan = (JsonRenderer.JsonRenderedNode)PLAN_CODEC.fromJson((String)Iterables.getOnlyElement(testQueryResult.get().getResults()));
        return new ExplainMatchResult(this.match(controlPlan, testPlan));
    }

    @Override
    protected DeterminismAnalysisDetails analyzeDeterminism(QueryBundle control, ExplainMatchResult matchResult) {
        throw new UnsupportedOperationException("analyzeDeterminism is not supported for ExplainVerification");
    }

    @Override
    protected Optional<String> resolveFailure(Optional<QueryBundle> control, Optional<QueryBundle> test, AbstractVerification.QueryContext controlQueryContext, Optional<ExplainMatchResult> matchResult, Optional<Throwable> throwable) {
        return Optional.empty();
    }

    @Override
    protected void updateQueryInfo(QueryInfo.Builder queryInfo, Optional<QueryResult<String>> queryResult) {
        queryResult.ifPresent(result -> queryInfo.setJsonPlan((String)Iterables.getOnlyElement(result.getResults())));
    }

    private ExplainMatchResult.MatchType match(JsonRenderer.JsonRenderedNode controlPlan, JsonRenderer.JsonRenderedNode testPlan) {
        if (!(Objects.equals(controlPlan.getName(), testPlan.getName()) && Objects.equals(controlPlan.getIdentifier(), testPlan.getIdentifier()) && Objects.equals(controlPlan.getRemoteSources(), testPlan.getRemoteSources()) && controlPlan.getChildren().size() == testPlan.getChildren().size())) {
            return ExplainMatchResult.MatchType.STRUCTURE_MISMATCH;
        }
        boolean detailsMismatched = !Objects.equals(controlPlan.getDetails(), testPlan.getDetails());
        for (int i = 0; i < controlPlan.getChildren().size(); ++i) {
            ExplainMatchResult.MatchType childMatchType = this.match((JsonRenderer.JsonRenderedNode)controlPlan.getChildren().get(i), (JsonRenderer.JsonRenderedNode)testPlan.getChildren().get(i));
            if (childMatchType == ExplainMatchResult.MatchType.STRUCTURE_MISMATCH) {
                return ExplainMatchResult.MatchType.STRUCTURE_MISMATCH;
            }
            if (childMatchType != ExplainMatchResult.MatchType.DETAILS_MISMATCH) continue;
            detailsMismatched = true;
        }
        return detailsMismatched ? ExplainMatchResult.MatchType.DETAILS_MISMATCH : ExplainMatchResult.MatchType.MATCH;
    }
}

