/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.verifier.event.QueryFailure;
import com.facebook.presto.verifier.framework.QueryException;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class VerificationContext {
    private final String sourceQueryName;
    private final String suite;
    private final int resubmissionCount;
    private final Set<QueryException> queryExceptions;

    private VerificationContext(String sourceQueryName, String suite, int resubmissionCount, Set<QueryException> queryExceptions) {
        this.sourceQueryName = Objects.requireNonNull(sourceQueryName, "sourceQueryName is null");
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.resubmissionCount = resubmissionCount;
        this.queryExceptions = new HashSet<QueryException>(queryExceptions);
    }

    public static VerificationContext create(String sourceQueryName, String suite) {
        return new VerificationContext(sourceQueryName, suite, 0, new HashSet<QueryException>());
    }

    public static VerificationContext createForResubmission(VerificationContext existing) {
        return new VerificationContext(existing.sourceQueryName, existing.suite, existing.resubmissionCount + 1, existing.queryExceptions);
    }

    public String getSourceQueryName() {
        return this.sourceQueryName;
    }

    public String getSuite() {
        return this.suite;
    }

    public int getResubmissionCount() {
        return this.resubmissionCount;
    }

    public void addException(QueryException exception) {
        this.queryExceptions.add(exception);
    }

    public List<QueryFailure> getQueryFailures() {
        return (List)this.queryExceptions.stream().map(QueryException::toQueryFailure).collect(ImmutableList.toImmutableList());
    }
}

