/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.prestoaction.JdbcPrestoAction;
import com.facebook.presto.verifier.prestoaction.PrestoActionConfig;
import com.facebook.presto.verifier.prestoaction.PrestoActionFactory;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.retry.RetryConfig;
import io.airlift.units.Duration;
import java.util.Objects;

public class JdbcPrestoActionFactory
implements PrestoActionFactory {
    private final SqlExceptionClassifier exceptionClassifier;
    private final PrestoActionConfig prestoActionConfig;
    private final RetryConfig networkRetryConfig;
    private final RetryConfig prestoRetryConfig;
    private final Duration metadataTimeout;
    private final Duration checksumTimeout;
    private final VerifierConfig verifierConfig;

    public JdbcPrestoActionFactory(SqlExceptionClassifier exceptionClassifier, PrestoActionConfig prestoActionConfig, RetryConfig networkRetryConfig, RetryConfig prestoRetryConfig, Duration metadataTimeout, Duration checksumTimeout, VerifierConfig verifierConfig) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.prestoActionConfig = Objects.requireNonNull(prestoActionConfig, "prestoClusterConfig is null");
        this.networkRetryConfig = Objects.requireNonNull(networkRetryConfig, "networkRetryConfig is null");
        this.prestoRetryConfig = Objects.requireNonNull(prestoRetryConfig, "prestoRetryConfig is null");
        this.metadataTimeout = Objects.requireNonNull(metadataTimeout, "metadataTimeout is null");
        this.checksumTimeout = Objects.requireNonNull(checksumTimeout, "checksumTimeout is null");
        this.verifierConfig = Objects.requireNonNull(verifierConfig, "verifierConfig is null");
    }

    @Override
    public JdbcPrestoAction create(QueryConfiguration queryConfiguration, VerificationContext verificationContext) {
        return new JdbcPrestoAction(this.exceptionClassifier, queryConfiguration, verificationContext, this.prestoActionConfig, this.metadataTimeout, this.checksumTimeout, this.networkRetryConfig, this.prestoRetryConfig, this.verifierConfig);
    }
}

