/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.prestoaction;

import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.facebook.presto.verifier.prestoaction.QueryAction;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class QueryActions {
    private final PrestoAction helperAction;
    private final QueryAction controlAction;
    private final QueryAction testAction;

    public QueryActions(PrestoAction helperAction, QueryAction controlAction, QueryAction testAction) {
        this.helperAction = Objects.requireNonNull(helperAction, "helperAction is null");
        this.controlAction = Objects.requireNonNull(controlAction, "controlAction is null");
        this.testAction = Objects.requireNonNull(testAction, "testAction is null");
    }

    public PrestoAction getHelperAction() {
        return this.helperAction;
    }

    public QueryAction getControlAction() {
        return this.controlAction;
    }

    public QueryAction getTestAction() {
        return this.testAction;
    }

    public QueryAction getQueryAction(ClusterType clusterType) {
        Preconditions.checkArgument((clusterType == ClusterType.CONTROL || clusterType == ClusterType.TEST ? 1 : 0) != 0, (String)"Invalid ClusterType: %s", (Object)((Object)clusterType));
        return clusterType == ClusterType.CONTROL ? this.getControlAction() : this.getTestAction();
    }
}

