/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.verifier.framework.DataMatchResult;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryObjectBundle;
import com.facebook.presto.verifier.prestoaction.QueryActionStats;
import com.facebook.presto.verifier.resolver.FailureResolver;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FailureResolverManager {
    private final Set<FailureResolver> failureResolvers;

    public FailureResolverManager(Set<FailureResolver> failureResolvers) {
        this.failureResolvers = Objects.requireNonNull(failureResolvers, "failureResolvers is null");
    }

    public Optional<String> resolveException(QueryActionStats controlStats, Throwable throwable, Optional<QueryObjectBundle> test) {
        if (!(throwable instanceof QueryException)) {
            return Optional.of("Verifier Error");
        }
        for (FailureResolver failureResolver : this.failureResolvers) {
            Optional<String> resolveMessage;
            if (!controlStats.getQueryStats().isPresent() || !(resolveMessage = failureResolver.resolveQueryFailure(controlStats.getQueryStats().get(), (QueryException)throwable, test)).isPresent()) continue;
            return resolveMessage;
        }
        return Optional.empty();
    }

    public Optional<String> resolveResultMismatch(DataMatchResult matchResult, QueryBundle control) {
        for (FailureResolver failureResolver : this.failureResolvers) {
            Optional<String> resolveMessage = failureResolver.resolveResultMismatch(matchResult, control);
            if (!resolveMessage.isPresent()) continue;
            return resolveMessage;
        }
        return Optional.empty();
    }
}

