/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Optional;

public class HiveManifestUtils {
    private static final int FILE_SIZE_CHANNEL = 0;
    private static final int ROW_COUNT_CHANNEL = 1;

    private HiveManifestUtils() {
    }

    public static Page createFileStatisticsPage(long fileSize, long rowCount) {
        PageBuilder statsPageBuilder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        statsPageBuilder.declarePosition();
        BigintType.BIGINT.writeLong(statsPageBuilder.getBlockBuilder(0), fileSize);
        BigintType.BIGINT.writeLong(statsPageBuilder.getBlockBuilder(1), rowCount);
        return statsPageBuilder.build();
    }

    public static long getFileSize(Page statisticsPage, int position) {
        if (position < 0 || position >= statisticsPage.getPositionCount()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.MALFORMED_HIVE_FILE_STATISTICS, String.format("Invalid position: %d specified for FileStatistics page", position));
        }
        return BigintType.BIGINT.getLong(statisticsPage.getBlock(0), position);
    }

    public static Optional<Page> createPartitionManifest(PartitionUpdate partitionUpdate) {
        PageBuilder manifestBuilder = new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT));
        BlockBuilder fileNameBuilder = manifestBuilder.getBlockBuilder(0);
        BlockBuilder fileSizeBuilder = manifestBuilder.getBlockBuilder(1);
        for (PartitionUpdate.FileWriteInfo fileWriteInfo : partitionUpdate.getFileWriteInfos()) {
            if (!fileWriteInfo.getFileSize().isPresent()) {
                return Optional.empty();
            }
            manifestBuilder.declarePosition();
            VarcharType.VARCHAR.writeSlice(fileNameBuilder, Slices.utf8Slice((String)fileWriteInfo.getWriteFileName()));
            BigintType.BIGINT.writeLong(fileSizeBuilder, fileWriteInfo.getFileSize().get().longValue());
        }
        return Optional.of(manifestBuilder.build());
    }
}

