/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.ForFileRename;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveEncryptionInformationProvider;
import com.facebook.presto.hive.HiveFileRenamer;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionStats;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.PartitionObjectBuilder;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ZeroRowFileCreator;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.statistics.MetastoreHiveStatisticsProvider;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterStatsCalculatorService;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.joda.time.DateTimeZone;

public class HiveMetadataFactory
implements Supplier<TransactionalMetadata> {
    private static final Logger log = Logger.get(HiveMetadataFactory.class);
    private final boolean allowCorruptWritesForTesting;
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final int maxPartitionBatchSize;
    private final long perTransactionCacheMaximumSize;
    private final ExtendedHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final DateTimeZone timeZone;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final StandardFunctionResolution functionResolution;
    private final RowExpressionService rowExpressionService;
    private final FilterStatsCalculatorService filterStatsCalculatorService;
    private final TableParameterCodec tableParameterCodec;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final ListeningExecutorService fileRenameExecutor;
    private final TypeTranslator typeTranslator;
    private final StagingFileCommitter stagingFileCommitter;
    private final ZeroRowFileCreator zeroRowFileCreator;
    private final String prestoVersion;
    private final PartitionObjectBuilder partitionObjectBuilder;
    private final HiveEncryptionInformationProvider encryptionInformationProvider;
    private final HivePartitionStats hivePartitionStats;
    private final HiveFileRenamer hiveFileRenamer;

    @Inject
    public HiveMetadataFactory(HiveClientConfig hiveClientConfig, MetastoreClientConfig metastoreClientConfig, ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, @ForFileRename ListeningExecutorService fileRenameExecutor, TypeManager typeManager, LocationService locationService, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, FilterStatsCalculatorService filterStatsCalculatorService, TableParameterCodec tableParameterCodec, JsonCodec<PartitionUpdate> partitionUpdateCodec, TypeTranslator typeTranslator, StagingFileCommitter stagingFileCommitter, ZeroRowFileCreator zeroRowFileCreator, NodeVersion nodeVersion, PartitionObjectBuilder partitionObjectBuilder, HiveEncryptionInformationProvider encryptionInformationProvider, HivePartitionStats hivePartitionStats, HiveFileRenamer hiveFileRenamer) {
        this(metastore, hdfsEnvironment, partitionManager, hiveClientConfig.getDateTimeZone(), hiveClientConfig.getAllowCorruptWritesForTesting(), hiveClientConfig.isSkipDeletionForAlter(), hiveClientConfig.isSkipTargetCleanupOnRollback(), hiveClientConfig.getWritesToNonManagedTablesEnabled(), hiveClientConfig.getCreatesOfNonManagedTablesEnabled(), hiveClientConfig.getMaxPartitionBatchSize(), metastoreClientConfig.getPerTransactionMetastoreCacheMaximumSize(), typeManager, locationService, functionResolution, rowExpressionService, filterStatsCalculatorService, tableParameterCodec, partitionUpdateCodec, fileRenameExecutor, typeTranslator, stagingFileCommitter, zeroRowFileCreator, nodeVersion.toString(), partitionObjectBuilder, encryptionInformationProvider, hivePartitionStats, hiveFileRenamer);
    }

    public HiveMetadataFactory(ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, DateTimeZone timeZone, boolean allowCorruptWritesForTesting, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, int maxPartitionBatchSize, long perTransactionCacheMaximumSize, TypeManager typeManager, LocationService locationService, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, FilterStatsCalculatorService filterStatsCalculatorService, TableParameterCodec tableParameterCodec, JsonCodec<PartitionUpdate> partitionUpdateCodec, ListeningExecutorService fileRenameExecutor, TypeTranslator typeTranslator, StagingFileCommitter stagingFileCommitter, ZeroRowFileCreator zeroRowFileCreator, String prestoVersion, PartitionObjectBuilder partitionObjectBuilder, HiveEncryptionInformationProvider encryptionInformationProvider, HivePartitionStats hivePartitionStats, HiveFileRenamer hiveFileRenamer) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.perTransactionCacheMaximumSize = perTransactionCacheMaximumSize;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.filterStatsCalculatorService = Objects.requireNonNull(filterStatsCalculatorService, "filterStatsCalculatorService is null");
        this.tableParameterCodec = Objects.requireNonNull(tableParameterCodec, "tableParameterCodec is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.fileRenameExecutor = Objects.requireNonNull(fileRenameExecutor, "fileRenameExecutor is null");
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        this.stagingFileCommitter = Objects.requireNonNull(stagingFileCommitter, "stagingFileCommitter is null");
        this.zeroRowFileCreator = Objects.requireNonNull(zeroRowFileCreator, "zeroRowFileCreator is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        this.partitionObjectBuilder = Objects.requireNonNull(partitionObjectBuilder, "partitionObjectBuilder is null");
        this.encryptionInformationProvider = Objects.requireNonNull(encryptionInformationProvider, "encryptionInformationProvider is null");
        this.hivePartitionStats = Objects.requireNonNull(hivePartitionStats, "hivePartitionStats is null");
        this.hiveFileRenamer = Objects.requireNonNull(hiveFileRenamer, "hiveFileRenamer is null");
        if (!allowCorruptWritesForTesting && !timeZone.equals((Object)DateTimeZone.getDefault())) {
            log.warn("Hive writes are disabled. To write data to Hive, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments", new Object[]{timeZone.getID()});
        }
    }

    @Override
    public HiveMetadata get() {
        SemiTransactionalHiveMetastore metastore = new SemiTransactionalHiveMetastore(this.hdfsEnvironment, (ExtendedHiveMetastore)CachingHiveMetastore.memoizeMetastore((ExtendedHiveMetastore)this.metastore, (long)this.perTransactionCacheMaximumSize), this.fileRenameExecutor, this.skipDeletionForAlter, this.skipTargetCleanupOnRollback);
        return new HiveMetadata(metastore, this.hdfsEnvironment, this.partitionManager, this.timeZone, this.allowCorruptWritesForTesting, this.writesToNonManagedTablesEnabled, this.createsOfNonManagedTablesEnabled, this.maxPartitionBatchSize, this.typeManager, this.locationService, this.functionResolution, this.rowExpressionService, this.filterStatsCalculatorService, this.tableParameterCodec, this.partitionUpdateCodec, this.typeTranslator, this.prestoVersion, new MetastoreHiveStatisticsProvider(metastore), this.stagingFileCommitter, this.zeroRowFileCreator, this.partitionObjectBuilder, this.encryptionInformationProvider, this.hivePartitionStats, this.hiveFileRenamer);
    }
}

