/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class HiveTableProperties {
    public static final String EXTERNAL_LOCATION_PROPERTY = "external_location";
    public static final String STORAGE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    public static final String BUCKETED_BY_PROPERTY = "bucketed_by";
    public static final String BUCKET_COUNT_PROPERTY = "bucket_count";
    public static final String SORTED_BY_PROPERTY = "sorted_by";
    public static final String ORC_BLOOM_FILTER_COLUMNS = "orc_bloom_filter_columns";
    public static final String ORC_BLOOM_FILTER_FPP = "orc_bloom_filter_fpp";
    public static final String AVRO_SCHEMA_URL = "avro_schema_url";
    public static final String PREFERRED_ORDERING_COLUMNS = "preferred_ordering_columns";
    public static final String ENCRYPT_COLUMNS = "encrypt_columns";
    public static final String ENCRYPT_TABLE = "encrypt_table";
    public static final String DWRF_ENCRYPTION_ALGORITHM = "dwrf_encryption_algorithm";
    public static final String DWRF_ENCRYPTION_PROVIDER = "dwrf_encryption_provider";
    public static final String CSV_SEPARATOR = "csv_separator";
    public static final String CSV_QUOTE = "csv_quote";
    public static final String CSV_ESCAPE = "csv_escape";
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public HiveTableProperties(TypeManager typeManager, HiveClientConfig config) {
        this.tableProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)EXTERNAL_LOCATION_PROPERTY, (String)"File system location URI for external table", null, (boolean)false), (Object)new PropertyMetadata(STORAGE_FORMAT_PROPERTY, "Hive storage format for the table", (Type)VarcharType.createUnboundedVarcharType(), HiveStorageFormat.class, (Object)config.getHiveStorageFormat(), false, value -> HiveStorageFormat.valueOf((String)((String)value).toUpperCase(Locale.ENGLISH)), Enum::toString), (Object)new PropertyMetadata(PARTITIONED_BY_PROPERTY, "Partition columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value), (Object)new PropertyMetadata(BUCKETED_BY_PROPERTY, "Bucketing columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value), (Object)new PropertyMetadata(SORTED_BY_PROPERTY, "Bucket sorting columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> (ImmutableList)((Collection)value).stream().map(String.class::cast).map(SortingColumn::sortingColumnFromString).collect(ImmutableList.toImmutableList()), value -> (ImmutableList)value.stream().map(SortingColumn.class::cast).map(SortingColumn::sortingColumnToString).collect(ImmutableList.toImmutableList())), (Object)new PropertyMetadata(ORC_BLOOM_FILTER_COLUMNS, "ORC Bloom filter index columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> (ImmutableList)((Collection)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.doubleProperty((String)ORC_BLOOM_FILTER_FPP, (String)"ORC Bloom filter false positive probability", (Double)config.getOrcDefaultBloomFilterFpp(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)BUCKET_COUNT_PROPERTY, (String)"Number of buckets", (Integer)0, (boolean)false), (Object)PropertyMetadata.stringProperty((String)AVRO_SCHEMA_URL, (String)"URI pointing to Avro schema for the table", null, (boolean)false), (Object)new PropertyMetadata(PREFERRED_ORDERING_COLUMNS, "Preferred ordering columns for unbucketed table", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> (ImmutableList)((Collection)value).stream().map(String.class::cast).map(SortingColumn::sortingColumnFromString).collect(ImmutableList.toImmutableList()), value -> (ImmutableList)value.stream().map(SortingColumn.class::cast).map(SortingColumn::sortingColumnToString).collect(ImmutableList.toImmutableList())), (Object)PropertyMetadata.stringProperty((String)ENCRYPT_TABLE, (String)"Key reference for encrypting the whole table", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)DWRF_ENCRYPTION_ALGORITHM, (String)"Algorithm used for encryption data in DWRF", null, (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.stringProperty((String)DWRF_ENCRYPTION_PROVIDER, (String)"Provider for encryption keys in provider", null, (boolean)false), PropertyMetadata.stringProperty((String)CSV_SEPARATOR, (String)"CSV separator character", null, (boolean)false), PropertyMetadata.stringProperty((String)CSV_QUOTE, (String)"CSV quote character", null, (boolean)false), PropertyMetadata.stringProperty((String)CSV_ESCAPE, (String)"CSV escape character", null, (boolean)false), new PropertyMetadata(ENCRYPT_COLUMNS, "List of key references and columns being encrypted. Example: ARRAY['key1:col1,col2', 'key2:col3,col4']", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), ColumnEncryptionInformation.class, null, false, ColumnEncryptionInformation::fromTableProperty, ColumnEncryptionInformation::toTableProperty)});
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static String getExternalLocation(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(EXTERNAL_LOCATION_PROPERTY);
    }

    public static String getAvroSchemaUrl(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(AVRO_SCHEMA_URL);
    }

    public static HiveStorageFormat getHiveStorageFormat(Map<String, Object> tableProperties) {
        return (HiveStorageFormat)tableProperties.get(STORAGE_FORMAT_PROPERTY);
    }

    public static List<String> getPartitionedBy(Map<String, Object> tableProperties) {
        List partitionedBy = (List)tableProperties.get(PARTITIONED_BY_PROPERTY);
        return partitionedBy == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitionedBy);
    }

    public static Optional<HiveBucketProperty> getBucketProperty(Map<String, Object> tableProperties) {
        List<String> bucketedBy = HiveTableProperties.getBucketedBy(tableProperties);
        List<SortingColumn> sortedBy = HiveTableProperties.getSortedBy(tableProperties);
        int bucketCount = (Integer)tableProperties.get(BUCKET_COUNT_PROPERTY);
        if (bucketedBy.isEmpty() && bucketCount == 0) {
            if (!sortedBy.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s may be specified only when %s is specified", SORTED_BY_PROPERTY, BUCKETED_BY_PROPERTY));
            }
            return Optional.empty();
        }
        if (bucketCount < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be greater than zero", BUCKET_COUNT_PROPERTY));
        }
        if (bucketCount > 1000000) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s should be no more than 1000000", BUCKET_COUNT_PROPERTY));
        }
        if (bucketedBy.isEmpty() || bucketCount == 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s and %s must be specified together", BUCKETED_BY_PROPERTY, BUCKET_COUNT_PROPERTY));
        }
        return Optional.of(new HiveBucketProperty(bucketedBy, bucketCount, sortedBy, BucketFunctionType.HIVE_COMPATIBLE, Optional.empty()));
    }

    private static List<String> getBucketedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(BUCKETED_BY_PROPERTY);
    }

    private static List<SortingColumn> getSortedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(SORTED_BY_PROPERTY);
    }

    public static List<String> getOrcBloomFilterColumns(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(ORC_BLOOM_FILTER_COLUMNS);
    }

    public static Double getOrcBloomFilterFpp(Map<String, Object> tableProperties) {
        return (Double)tableProperties.get(ORC_BLOOM_FILTER_FPP);
    }

    public static Optional<Character> getCsvProperty(Map<String, Object> tableProperties, String key) {
        Object value = tableProperties.get(key);
        if (value == null) {
            return Optional.empty();
        }
        String csvValue = (String)value;
        if (csvValue.length() != 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be a single character string, but was: '%s'", key, csvValue));
        }
        return Optional.of(Character.valueOf(csvValue.charAt(0)));
    }

    public static List<SortingColumn> getPreferredOrderingColumns(Map<String, Object> tableProperties) {
        List preferredOrderingColumns = (List)tableProperties.get(PREFERRED_ORDERING_COLUMNS);
        if (preferredOrderingColumns == null) {
            return ImmutableList.of();
        }
        if (!preferredOrderingColumns.isEmpty() && HiveTableProperties.getBucketProperty(tableProperties).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must not be specified when %s is specified", PREFERRED_ORDERING_COLUMNS, BUCKETED_BY_PROPERTY));
        }
        return preferredOrderingColumns;
    }

    public static String getEncryptTable(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(ENCRYPT_TABLE);
    }

    public static String getDwrfEncryptionAlgorithm(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(DWRF_ENCRYPTION_ALGORITHM);
    }

    public static String getDwrfEncryptionProvider(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(DWRF_ENCRYPTION_PROVIDER);
    }

    public static ColumnEncryptionInformation getEncryptColumns(Map<String, Object> tableProperties) {
        return tableProperties.containsKey(ENCRYPT_COLUMNS) ? (ColumnEncryptionInformation)tableProperties.get(ENCRYPT_COLUMNS) : ColumnEncryptionInformation.fromMap((Map)ImmutableMap.of());
    }
}

