/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.hadoop.TextLineLengthLimitExceededException;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.avro.PrestoAvroSerDe;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.pagefile.PageInputFormat;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.hive.util.CustomSplitConversionUtils;
import com.facebook.presto.hive.util.FooterAwareRecordReader;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.compress.lzo.LzoCodec;
import io.airlift.compress.lzo.LzopCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.ISODateTimeFormat;

public final class HiveUtil {
    private static final Pattern DEFAULT_HIVE_COLUMN_NAME_PATTERN = Pattern.compile("_col\\d+");
    private static final String VIEW_PREFIX = "/* Presto View: ";
    private static final String VIEW_SUFFIX = " */";
    private static final DateTimeFormatter HIVE_DATE_PARSER = ISODateTimeFormat.date().withZoneUTC();
    private static final DateTimeFormatter HIVE_TIMESTAMP_PARSER;
    private static final Field COMPRESSION_CODECS_FIELD;
    private static final Pattern SUPPORTED_DECIMAL_TYPE;
    private static final int DECIMAL_PRECISION_GROUP = 1;
    private static final int DECIMAL_SCALE_GROUP = 2;
    private static final String BIG_DECIMAL_POSTFIX = "BD";

    private HiveUtil() {
    }

    public static RecordReader<?, ?> createRecordReader(Configuration configuration, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns, Map<String, String> customSplitInfo) {
        ImmutableList readColumns = ImmutableList.copyOf((Iterable)Iterables.filter(columns, column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR));
        ImmutableList readHiveColumnIndexes = ImmutableList.copyOf((Collection)Lists.transform((List)readColumns, HiveColumnHandle::getHiveColumnIndex));
        HiveUtil.setReadColumns(configuration, (List<Integer>)readHiveColumnIndexes);
        Predicate schemaFilter = schemaProperty -> schemaProperty.startsWith("serialization.");
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, HiveUtil.getInputFormatName(schema), true);
        JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
        FileSplit fileSplit = new FileSplit(path, start, length, (String[])null);
        if (!customSplitInfo.isEmpty() && HiveUtil.isHudiRealtimeSplit(customSplitInfo)) {
            fileSplit = CustomSplitConversionUtils.recreateSplitWithCustomInfo(fileSplit, customSplitInfo);
            ImmutableList readHiveColumnNames = ImmutableList.copyOf((Collection)Lists.transform((List)readColumns, HiveColumnHandle::getName));
            jobConf.set("hive.io.file.readcolumn.names", Joiner.on((char)',').join((Iterable)readHiveColumnNames));
            schemaFilter = schemaProperty -> true;
        }
        schema.stringPropertyNames().stream().filter(schemaFilter).forEach(name -> jobConf.set(name, schema.getProperty((String)name)));
        ArrayList codecs = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)jobConf.get("io.compression.codecs", "")));
        if (!codecs.contains(LzoCodec.class.getName())) {
            codecs.add(0, LzoCodec.class.getName());
        }
        if (!codecs.contains(LzopCodec.class.getName())) {
            codecs.add(0, LzopCodec.class.getName());
        }
        jobConf.set("io.compression.codecs", codecs.stream().collect(Collectors.joining(",")));
        try {
            int footerCount;
            FooterAwareRecordReader recordReader = inputFormat.getRecordReader((InputSplit)fileSplit, jobConf, Reporter.NULL);
            int headerCount = HiveUtil.getHeaderCount(schema);
            if (start == 0L && headerCount > 0) {
                Utilities.skipHeader((RecordReader)recordReader, (int)headerCount, (WritableComparable)((WritableComparable)recordReader.createKey()), (Writable)((Writable)recordReader.createValue()));
            }
            if ((footerCount = HiveUtil.getFooterCount(schema)) > 0) {
                recordReader = new FooterAwareRecordReader(recordReader, footerCount, jobConf);
            }
            return recordReader;
        }
        catch (IOException e) {
            if (e instanceof TextLineLengthLimitExceededException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Line too long in text file: " + path, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, String.format("Error opening Hive split %s (offset=%s, length=%s) using %s: %s", path, start, length, HiveUtil.getInputFormatName(schema), MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e.getClass().getName())), (Throwable)e);
        }
    }

    private static boolean isHudiRealtimeSplit(Map<String, String> customSplitInfo) {
        String customSplitClass = customSplitInfo.get("custom_split_class");
        return HoodieRealtimeFileSplit.class.getName().equals(customSplitClass);
    }

    public static void setReadColumns(Configuration configuration, List<Integer> readHiveColumnIndexes) {
        configuration.set("hive.io.file.readcolumn.ids", Joiner.on((char)',').join(readHiveColumnIndexes));
        configuration.setBoolean("hive.io.file.read.all.columns", false);
    }

    public static Optional<CompressionCodec> getCompressionCodec(TextInputFormat inputFormat, Path file) {
        CompressionCodecFactory compressionCodecFactory;
        try {
            compressionCodecFactory = (CompressionCodecFactory)COMPRESSION_CODECS_FIELD.get(inputFormat);
        }
        catch (IllegalAccessException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to find compressionCodec for inputFormat: " + inputFormat.getClass().getName(), (Throwable)e);
        }
        if (compressionCodecFactory == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(compressionCodecFactory.getCodec(file));
    }

    public static InputFormat<?, ?> getInputFormat(Configuration configuration, String inputFormatName, boolean symlinkTarget) {
        try {
            JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
            Class<? extends InputFormat<?, ?>> inputFormatClass = HiveUtil.getInputFormatClass(jobConf, inputFormatName);
            if (symlinkTarget && inputFormatClass == SymlinkTextInputFormat.class) {
                inputFormatClass = TextInputFormat.class;
            }
            return (InputFormat)ReflectionUtils.newInstance(inputFormatClass, (Configuration)jobConf);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Unable to create input format " + inputFormatName, (Throwable)e);
        }
    }

    private static Class<? extends InputFormat<?, ?>> getInputFormatClass(JobConf conf, String inputFormatName) throws ClassNotFoundException {
        if ("parquet.hive.DeprecatedParquetInputFormat".equals(inputFormatName) || "parquet.hive.MapredParquetInputFormat".equals(inputFormatName)) {
            return MapredParquetInputFormat.class;
        }
        if (PageInputFormat.class.getSimpleName().equals(inputFormatName)) {
            return PageInputFormat.class;
        }
        Class clazz = conf.getClassByName(inputFormatName);
        return clazz.asSubclass(InputFormat.class);
    }

    static String getInputFormatName(Properties schema) {
        String name = schema.getProperty("file.inputformat");
        MetastoreUtil.checkCondition((name != null ? 1 : 0) != 0, (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, (String)"Table or partition is missing Hive input format property: %s", (Object[])new Object[]{"file.inputformat"});
        return name;
    }

    public static boolean shouldUseRecordReaderFromInputFormat(Configuration configuration, Storage storage) {
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, storage.getStorageFormat().getInputFormat(), false);
        return Arrays.stream(inputFormat.getClass().getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch(name -> name.equals("UseRecordReaderFromInputFormat"));
    }

    public static long parseHiveDate(String value) {
        long millis = HIVE_DATE_PARSER.parseMillis(value);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    public static long parseHiveTimestamp(String value, DateTimeZone timeZone) {
        return HIVE_TIMESTAMP_PARSER.withZone(timeZone).parseMillis(value);
    }

    public static boolean isSplittable(InputFormat<?, ?> inputFormat, FileSystem fileSystem, Path path) {
        if (inputFormat.getClass().getSimpleName().equals("OrcInputFormat") || inputFormat.getClass().getSimpleName().equals("RCFileInputFormat")) {
            return true;
        }
        Method method = null;
        for (Class<?> clazz = inputFormat.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod("isSplitable", FileSystem.class, Path.class);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null) {
            return false;
        }
        try {
            method.setAccessible(true);
            return (Boolean)method.invoke(inputFormat, fileSystem, path);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static StructObjectInspector getTableObjectInspector(Deserializer deserializer) {
        try {
            ObjectInspector inspector = deserializer.getObjectInspector();
            Preconditions.checkArgument((inspector.getCategory() == ObjectInspector.Category.STRUCT ? 1 : 0) != 0, (String)"expected STRUCT: %s", (Object)inspector.getCategory());
            return (StructObjectInspector)inspector;
        }
        catch (SerDeException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isDeserializerClass(Properties schema, Class<?> deserializerClass) {
        return HiveUtil.getDeserializerClassName(schema).equals(deserializerClass.getName());
    }

    public static String getDeserializerClassName(Properties schema) {
        String name = schema.getProperty("serialization.lib");
        MetastoreUtil.checkCondition((name != null ? 1 : 0) != 0, (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, (String)"Table or partition is missing Hive deserializer property: %s", (Object[])new Object[]{"serialization.lib"});
        return name;
    }

    public static Deserializer getDeserializer(Configuration configuration, Properties schema) {
        String name = HiveUtil.getDeserializerClassName(schema);
        Deserializer deserializer = HiveUtil.createDeserializer(HiveUtil.getDeserializerClass(name));
        HiveUtil.initializeDeserializer(configuration, deserializer, schema);
        return deserializer;
    }

    private static Class<? extends Deserializer> getDeserializerClass(String name) {
        if ("parquet.hive.serde.ParquetHiveSerDe".equals(name)) {
            return ParquetHiveSerDe.class;
        }
        if ("org.apache.hadoop.hive.serde2.avro.AvroSerDe".equals(name)) {
            return PrestoAvroSerDe.class;
        }
        try {
            return Class.forName(name, true, JavaUtils.getClassLoader()).asSubclass(Deserializer.class);
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_SERDE_NOT_FOUND, "deserializer does not exist: " + name);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("invalid deserializer class: " + name);
        }
    }

    private static Deserializer createDeserializer(Class<? extends Deserializer> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("error creating deserializer: " + clazz.getName(), e);
        }
    }

    private static void initializeDeserializer(Configuration configuration, Deserializer deserializer, Properties schema) {
        try {
            configuration = ConfigurationUtils.copy(configuration);
            deserializer.initialize(configuration, schema);
            HiveUtil.validate(deserializer);
        }
        catch (RuntimeException | SerDeException e) {
            throw new RuntimeException("error initializing deserializer: " + deserializer.getClass().getName(), e);
        }
    }

    private static void validate(Deserializer deserializer) {
        if (deserializer instanceof AbstractSerDe && !((AbstractSerDe)deserializer).getConfigurationErrors().isEmpty()) {
            throw new RuntimeException("There are configuration errors: " + ((AbstractSerDe)deserializer).getConfigurationErrors());
        }
    }

    public static boolean isHiveNull(byte[] bytes) {
        return bytes.length == 2 && bytes[0] == 92 && bytes[1] == 78;
    }

    public static void verifyPartitionTypeSupported(String partitionName, Type type) {
        if (!HiveUtil.isValidPartitionType(type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported type [%s] for partition: %s", type, partitionName));
        }
    }

    private static boolean isValidPartitionType(Type type) {
        return type instanceof DecimalType || BooleanType.BOOLEAN.equals((Object)type) || TinyintType.TINYINT.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || RealType.REAL.equals((Object)type) || DoubleType.DOUBLE.equals((Object)type) || DateType.DATE.equals((Object)type) || TimestampType.TIMESTAMP.equals((Object)type) || Varchars.isVarcharType((Type)type) || Chars.isCharType((Type)type);
    }

    public static NullableValue parsePartitionValue(String partitionName, String value, Type type, DateTimeZone timeZone) {
        HiveUtil.verifyPartitionTypeSupported(partitionName, type);
        boolean isNull = "__HIVE_DEFAULT_PARTITION__".equals(value);
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (isNull) {
                return NullableValue.asNull((Type)decimalType);
            }
            if (decimalType.isShort()) {
                if (value.isEmpty()) {
                    return NullableValue.of((Type)decimalType, (Object)0L);
                }
                return NullableValue.of((Type)decimalType, (Object)HiveUtil.shortDecimalPartitionKey(value, decimalType, partitionName));
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)decimalType, (Object)Decimals.encodeUnscaledValue((BigInteger)BigInteger.ZERO));
            }
            return NullableValue.of((Type)decimalType, (Object)HiveUtil.longDecimalPartitionKey(value, decimalType, partitionName));
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)BooleanType.BOOLEAN);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)BooleanType.BOOLEAN, (Object)false);
            }
            return NullableValue.of((Type)BooleanType.BOOLEAN, (Object)HiveUtil.booleanPartitionKey(value, partitionName));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)TinyintType.TINYINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)TinyintType.TINYINT, (Object)0L);
            }
            return NullableValue.of((Type)TinyintType.TINYINT, (Object)HiveUtil.tinyintPartitionKey(value, partitionName));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)SmallintType.SMALLINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)SmallintType.SMALLINT, (Object)0L);
            }
            return NullableValue.of((Type)SmallintType.SMALLINT, (Object)HiveUtil.smallintPartitionKey(value, partitionName));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)IntegerType.INTEGER);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)IntegerType.INTEGER, (Object)0L);
            }
            return NullableValue.of((Type)IntegerType.INTEGER, (Object)HiveUtil.integerPartitionKey(value, partitionName));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)BigintType.BIGINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)BigintType.BIGINT, (Object)0L);
            }
            return NullableValue.of((Type)BigintType.BIGINT, (Object)HiveUtil.bigintPartitionKey(value, partitionName));
        }
        if (DateType.DATE.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)DateType.DATE);
            }
            return NullableValue.of((Type)DateType.DATE, (Object)HiveUtil.datePartitionKey(value, partitionName));
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)TimestampType.TIMESTAMP);
            }
            return NullableValue.of((Type)TimestampType.TIMESTAMP, (Object)HiveUtil.timestampPartitionKey(value, timeZone, partitionName));
        }
        if (RealType.REAL.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)RealType.REAL);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)RealType.REAL, (Object)Float.floatToRawIntBits(0.0f));
            }
            return NullableValue.of((Type)RealType.REAL, (Object)HiveUtil.floatPartitionKey(value, partitionName));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)DoubleType.DOUBLE);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)DoubleType.DOUBLE, (Object)0.0);
            }
            return NullableValue.of((Type)DoubleType.DOUBLE, (Object)HiveUtil.doublePartitionKey(value, partitionName));
        }
        if (Varchars.isVarcharType((Type)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)type);
            }
            return NullableValue.of((Type)type, (Object)HiveUtil.varcharPartitionKey(value, partitionName, type));
        }
        if (Chars.isCharType((Type)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)type);
            }
            return NullableValue.of((Type)type, (Object)HiveUtil.charPartitionKey(value, partitionName, type));
        }
        throw new VerifyException(String.format("Unhandled type [%s] for partition: %s", type, partitionName));
    }

    public static String encodeViewData(String data) {
        return VIEW_PREFIX + Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8)) + VIEW_SUFFIX;
    }

    public static String decodeViewData(String data) {
        MetastoreUtil.checkCondition((boolean)data.startsWith(VIEW_PREFIX), (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_VIEW_DATA, (String)"View data missing prefix: %s", (Object[])new Object[]{data});
        MetastoreUtil.checkCondition((boolean)data.endsWith(VIEW_SUFFIX), (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_VIEW_DATA, (String)"View data missing suffix: %s", (Object[])new Object[]{data});
        data = data.substring(VIEW_PREFIX.length());
        data = data.substring(0, data.length() - VIEW_SUFFIX.length());
        return new String(Base64.getDecoder().decode(data), StandardCharsets.UTF_8);
    }

    public static Optional<DecimalType> getDecimalType(HiveType hiveType) {
        return HiveUtil.getDecimalType(hiveType.getHiveTypeName().toString());
    }

    public static Optional<DecimalType> getDecimalType(String hiveTypeName) {
        Matcher matcher = SUPPORTED_DECIMAL_TYPE.matcher(hiveTypeName);
        if (matcher.matches()) {
            int precision = Integer.parseInt(matcher.group(1));
            int scale = Integer.parseInt(matcher.group(2));
            return Optional.of(DecimalType.createDecimalType((int)precision, (int)scale));
        }
        return Optional.empty();
    }

    public static boolean isStructuralType(Type type) {
        String baseName = type.getTypeSignature().getBase();
        return baseName.equals("map") || baseName.equals("array") || baseName.equals("row");
    }

    public static boolean isStructuralType(HiveType hiveType) {
        return hiveType.getCategory() == ObjectInspector.Category.LIST || hiveType.getCategory() == ObjectInspector.Category.MAP || hiveType.getCategory() == ObjectInspector.Category.STRUCT;
    }

    public static boolean booleanPartitionKey(String value, String name) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for BOOLEAN partition key: %s", value, name));
    }

    public static long bigintPartitionKey(String value, String name) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for BIGINT partition key: %s", value, name));
        }
    }

    public static long integerPartitionKey(String value, String name) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for INTEGER partition key: %s", value, name));
        }
    }

    public static long smallintPartitionKey(String value, String name) {
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for SMALLINT partition key: %s", value, name));
        }
    }

    public static long tinyintPartitionKey(String value, String name) {
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for TINYINT partition key: %s", value, name));
        }
    }

    public static long floatPartitionKey(String value, String name) {
        try {
            return Float.floatToRawIntBits(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for FLOAT partition key: %s", value, name));
        }
    }

    public static double doublePartitionKey(String value, String name) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for DOUBLE partition key: %s", value, name));
        }
    }

    public static long datePartitionKey(String value, String name) {
        try {
            return HiveUtil.parseHiveDate(value);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for DATE partition key: %s", value, name));
        }
    }

    public static long timestampPartitionKey(String value, DateTimeZone zone, String name) {
        try {
            return HiveUtil.parseHiveTimestamp(value, zone);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for TIMESTAMP partition key: %s", value, name));
        }
    }

    public static long shortDecimalPartitionKey(String value, DecimalType type, String name) {
        return HiveUtil.decimalPartitionKey(value, type, name).unscaledValue().longValue();
    }

    public static Slice longDecimalPartitionKey(String value, DecimalType type, String name) {
        return Decimals.encodeUnscaledValue((BigInteger)HiveUtil.decimalPartitionKey(value, type, name).unscaledValue());
    }

    private static BigDecimal decimalPartitionKey(String value, DecimalType type, String name) {
        try {
            if (value.endsWith(BIG_DECIMAL_POSTFIX)) {
                value = value.substring(0, value.length() - BIG_DECIMAL_POSTFIX.length());
            }
            BigDecimal decimal = new BigDecimal(value);
            if ((decimal = decimal.setScale(type.getScale(), 7)).precision() > type.getPrecision()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, type.toString(), name));
            }
            return decimal;
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, type.toString(), name));
        }
    }

    public static Slice varcharPartitionKey(String value, String name, Type columnType) {
        Slice partitionKey = Slices.utf8Slice((String)value);
        VarcharType varcharType = (VarcharType)columnType;
        if (SliceUtf8.countCodePoints((Slice)partitionKey) > varcharType.getLength()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, columnType.toString(), name));
        }
        return partitionKey;
    }

    public static Slice charPartitionKey(String value, String name, Type columnType) {
        Slice partitionKey = Chars.trimTrailingSpaces((Slice)Slices.utf8Slice((String)value));
        CharType charType = (CharType)columnType;
        if (SliceUtf8.countCodePoints((Slice)partitionKey) > charType.getLength()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, columnType.toString(), name));
        }
        return partitionKey;
    }

    public static SchemaTableName schemaTableName(ConnectorTableHandle tableHandle) {
        return ((HiveTableHandle)tableHandle).getSchemaTableName();
    }

    public static List<HiveColumnHandle> hiveColumnHandles(Table table) {
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll(HiveUtil.getRegularColumnHandles(table));
        columns.addAll(HiveUtil.getPartitionKeyColumnHandles(table));
        columns.add((Object)HiveColumnHandle.pathColumnHandle());
        if (table.getStorage().getBucketProperty().isPresent()) {
            columns.add((Object)HiveColumnHandle.bucketColumnHandle());
        }
        return columns.build();
    }

    public static List<HiveColumnHandle> getRegularColumnHandles(Table table) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int hiveColumnIndex = 0;
        for (Column field : table.getDataColumns()) {
            HiveType hiveType = field.getType();
            if (hiveType.isSupportedType()) {
                columns.add((Object)new HiveColumnHandle(field.getName(), hiveType, hiveType.getTypeSignature(), hiveColumnIndex, HiveColumnHandle.ColumnType.REGULAR, field.getComment(), Optional.empty()));
            }
            ++hiveColumnIndex;
        }
        return columns.build();
    }

    public static List<HiveColumnHandle> getPartitionKeyColumnHandles(Table table) {
        ImmutableList.Builder columns = ImmutableList.builder();
        List partitionKeys = table.getPartitionColumns();
        int partitionColumnIndex = -13;
        for (Column field : partitionKeys) {
            HiveType hiveType = field.getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            columns.add((Object)new HiveColumnHandle(field.getName(), hiveType, hiveType.getTypeSignature(), partitionColumnIndex--, HiveColumnHandle.ColumnType.PARTITION_KEY, field.getComment(), Optional.empty()));
        }
        return columns.build();
    }

    @Nullable
    public static String columnExtraInfo(boolean partitionKey) {
        return partitionKey ? "partition key" : null;
    }

    public static String getPrefilledColumnValue(HiveColumnHandle columnHandle, HivePartitionKey partitionKey, Path path, OptionalInt bucketNumber) {
        if (partitionKey != null) {
            return partitionKey.getValue();
        }
        if (HiveColumnHandle.isPathColumnHandle(columnHandle)) {
            return path.toString();
        }
        if (HiveColumnHandle.isBucketColumnHandle(columnHandle)) {
            if (!bucketNumber.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_BUCKETING_IS_IGNORED, "Table bucketing is ignored. The virtual \"$bucket\" column cannot be referenced.");
            }
            return String.valueOf(bucketNumber.getAsInt());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported hidden column: " + columnHandle);
    }

    public static void closeWithSuppression(RecordCursor recordCursor, Throwable throwable) {
        block2: {
            Objects.requireNonNull(recordCursor, "recordCursor is null");
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                recordCursor.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public static List<HiveType> extractStructFieldTypes(HiveType hiveType) {
        return (List)((StructTypeInfo)hiveType.getTypeInfo()).getAllStructFieldTypeInfos().stream().map(typeInfo -> HiveType.valueOf((String)typeInfo.getTypeName())).collect(ImmutableList.toImmutableList());
    }

    public static List<String> extractStructFieldNames(HiveType hiveType) {
        return ((StructTypeInfo)hiveType.getTypeInfo()).getAllStructFieldNames();
    }

    public static int getHeaderCount(Properties schema) {
        return HiveUtil.getPositiveIntegerValue(schema, "skip.header.line.count", "0");
    }

    public static int getFooterCount(Properties schema) {
        return HiveUtil.getPositiveIntegerValue(schema, "skip.footer.line.count", "0");
    }

    private static int getPositiveIntegerValue(Properties schema, String key, String defaultValue) {
        String value = schema.getProperty(key, defaultValue);
        try {
            int intValue = Integer.parseInt(value);
            if (intValue < 0) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", key, value));
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", key, value));
        }
    }

    public static Object typedPartitionKey(String value, Type type, String name, DateTimeZone hiveStorageTimeZone) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        if (HiveUtil.isHiveNull(bytes)) {
            return null;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return HiveUtil.booleanPartitionKey(value, name);
        }
        if (type.equals(BigintType.BIGINT)) {
            return HiveUtil.bigintPartitionKey(value, name);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return HiveUtil.integerPartitionKey(value, name);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return HiveUtil.smallintPartitionKey(value, name);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return HiveUtil.tinyintPartitionKey(value, name);
        }
        if (type.equals(RealType.REAL)) {
            return HiveUtil.floatPartitionKey(value, name);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return HiveUtil.doublePartitionKey(value, name);
        }
        if (Varchars.isVarcharType((Type)type)) {
            return HiveUtil.varcharPartitionKey(value, name, type);
        }
        if (Chars.isCharType((Type)type)) {
            return HiveUtil.charPartitionKey(value, name, type);
        }
        if (type.equals(DateType.DATE)) {
            return HiveUtil.datePartitionKey(value, name);
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return HiveUtil.timestampPartitionKey(value, hiveStorageTimeZone, name);
        }
        if (Decimals.isShortDecimal((Type)type)) {
            return HiveUtil.shortDecimalPartitionKey(value, (DecimalType)type, name);
        }
        if (Decimals.isLongDecimal((Type)type)) {
            return HiveUtil.longDecimalPartitionKey(value, (DecimalType)type, name);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for partition column: %s", type.getDisplayName(), name));
    }

    public static List<HiveColumnHandle> getPhysicalHiveColumnHandles(List<HiveColumnHandle> columns, boolean useOrcColumnNames, OrcReader reader, Path path) {
        if (!useOrcColumnNames) {
            return columns;
        }
        HiveUtil.verifyFileHasColumnNames(reader.getColumnNames(), path);
        Map<String, Integer> physicalNameOrdinalMap = HiveUtil.buildPhysicalNameOrdinalMap(reader);
        int nextMissingColumnIndex = physicalNameOrdinalMap.size();
        ImmutableList.Builder physicalColumns = ImmutableList.builder();
        for (HiveColumnHandle column : columns) {
            Integer physicalOrdinal = physicalNameOrdinalMap.get(column.getName());
            if (physicalOrdinal == null) {
                if (column.getHiveColumnIndex() < 0) {
                    physicalOrdinal = column.getHiveColumnIndex();
                } else {
                    physicalOrdinal = nextMissingColumnIndex;
                    ++nextMissingColumnIndex;
                }
            }
            physicalColumns.add((Object)new HiveColumnHandle(column.getName(), column.getHiveType(), column.getTypeSignature(), physicalOrdinal, column.getColumnType(), column.getComment(), column.getRequiredSubfields(), column.getPartialAggregation()));
        }
        return physicalColumns.build();
    }

    private static void verifyFileHasColumnNames(List<String> physicalColumnNames, Path path) {
        if (!physicalColumnNames.isEmpty() && physicalColumnNames.stream().allMatch(physicalColumnName -> DEFAULT_HIVE_COLUMN_NAME_PATTERN.matcher((CharSequence)physicalColumnName).matches())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_MISSING_COLUMN_NAMES, "ORC file does not contain column names in the footer: " + path);
        }
    }

    private static Map<String, Integer> buildPhysicalNameOrdinalMap(OrcReader reader) {
        ImmutableMap.Builder physicalNameOrdinalMap = ImmutableMap.builder();
        int ordinal = 0;
        for (String physicalColumnName : reader.getColumnNames()) {
            physicalNameOrdinalMap.put((Object)physicalColumnName, (Object)ordinal);
            ++ordinal;
        }
        return physicalNameOrdinalMap.build();
    }

    public static List<ColumnMetadata> translateHiveUnsupportedTypesForTemporaryTable(List<ColumnMetadata> columns, TypeManager typeManager) {
        return (List)columns.stream().map(column -> new ColumnMetadata(column.getName(), HiveUtil.translateHiveUnsupportedTypeForTemporaryTable(column.getType(), typeManager), column.isNullable(), column.getComment(), column.getExtraInfo(), column.isHidden(), column.getProperties())).collect(ImmutableList.toImmutableList());
    }

    public static Type translateHiveUnsupportedTypeForTemporaryTable(Type type, TypeManager typeManager) {
        return typeManager.getType(HiveUtil.translateHiveUnsupportedTypeSignatureForTemporaryTable(type.getTypeSignature()));
    }

    private static TypeSignature translateHiveUnsupportedTypeSignatureForTemporaryTable(TypeSignature typeSignature) {
        List parameters = typeSignature.getParameters();
        if (typeSignature.getBase().equals("unknown")) {
            return new TypeSignature("boolean", new TypeSignatureParameter[0]);
        }
        if (typeSignature.getBase().equals("row")) {
            ImmutableList.Builder updatedParameters = ImmutableList.builder();
            for (int i = 0; i < parameters.size(); ++i) {
                TypeSignatureParameter typeSignatureParameter = (TypeSignatureParameter)parameters.get(i);
                Preconditions.checkArgument((boolean)typeSignatureParameter.isNamedTypeSignature(), (String)"unexpected row type signature parameter: %s", (Object)typeSignatureParameter);
                NamedTypeSignature namedTypeSignature = typeSignatureParameter.getNamedTypeSignature();
                updatedParameters.add((Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(namedTypeSignature.getFieldName().orElse(new RowFieldName("_field_" + i, false))), HiveUtil.translateHiveUnsupportedTypeSignatureForTemporaryTable(namedTypeSignature.getTypeSignature()))));
            }
            return new TypeSignature("row", (List)updatedParameters.build());
        }
        if (!parameters.isEmpty()) {
            ImmutableList.Builder updatedParameters = ImmutableList.builder();
            block6: for (TypeSignatureParameter parameter : parameters) {
                switch (parameter.getKind()) {
                    case LONG: 
                    case VARIABLE: {
                        updatedParameters.add((Object)parameter);
                        continue block6;
                    }
                    case TYPE: {
                        updatedParameters.add((Object)TypeSignatureParameter.of((TypeSignature)HiveUtil.translateHiveUnsupportedTypeSignatureForTemporaryTable(parameter.getTypeSignature())));
                        continue block6;
                    }
                    case NAMED_TYPE: {
                        NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                        updatedParameters.add((Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(namedTypeSignature.getFieldName(), HiveUtil.translateHiveUnsupportedTypeSignatureForTemporaryTable(namedTypeSignature.getTypeSignature()))));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unexpected parameter type: " + parameter.getKind());
            }
            return new TypeSignature(typeSignature.getBase(), (List)updatedParameters.build());
        }
        return typeSignature;
    }

    static {
        SUPPORTED_DECIMAL_TYPE = Pattern.compile("decimal\\((\\d+),(\\d+)\\)");
        DateTimeParser[] timestampWithoutTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-M-d").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSSSS").getParser()};
        DateTimePrinter timestampWithoutTimeZonePrinter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS").getPrinter();
        HIVE_TIMESTAMP_PARSER = new DateTimeFormatterBuilder().append(timestampWithoutTimeZonePrinter, timestampWithoutTimeZoneParser).toFormatter().withZoneUTC();
        try {
            COMPRESSION_CODECS_FIELD = TextInputFormat.class.getDeclaredField("compressionCodecs");
            COMPRESSION_CODECS_FIELD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

