/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.block.LazyBlockLoader;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ParquetPageSource
implements ConnectorPageSource {
    private final ParquetReader parquetReader;
    private final List<String> columnNames;
    private final List<Type> types;
    private final List<Optional<Field>> fields;
    private int batchId;
    private long completedPositions;
    private boolean closed;

    public ParquetPageSource(ParquetReader parquetReader, List<Type> types, List<Optional<Field>> fields, List<String> columnNames) {
        this.parquetReader = Objects.requireNonNull(parquetReader, "parquetReader is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields is null"));
        this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
    }

    public long getCompletedBytes() {
        return this.parquetReader.getDataSource().getReadBytes();
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return this.parquetReader.getDataSource().getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public long getSystemMemoryUsage() {
        return this.parquetReader.getSystemMemoryContext().getBytes();
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            int batchSize = this.parquetReader.nextBatch();
            if (this.closed || batchSize <= 0) {
                this.close();
                return null;
            }
            this.completedPositions += (long)batchSize;
            Block[] blocks = new Block[this.fields.size()];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                Optional<Field> field = this.fields.get(fieldId);
                blocks[fieldId] = field.isPresent() ? new LazyBlock(batchSize, (LazyBlockLoader)new ParquetBlockLoader(field.get())) : RunLengthEncodedBlock.create((Type)this.types.get(fieldId), null, (int)batchSize);
            }
            return new Page(batchSize, blocks);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (e == throwable) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final class ParquetBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final Field field;
        private boolean loaded;

        public ParquetBlockLoader(Field field) {
            this.expectedBatchId = ParquetPageSource.this.batchId;
            this.field = Objects.requireNonNull(field, "field is null");
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((ParquetPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                Block block = ParquetPageSource.this.parquetReader.readBlock(this.field);
                lazyBlock.setBlock(block);
            }
            catch (ParquetCorruptionException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

