/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.OrcWriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.joda.time.DateTimeZone;

public class TempFileWriter
implements Closeable {
    private final OrcWriter orcWriter;

    public TempFileWriter(List<Type> types, DataSink sink) {
        this.orcWriter = TempFileWriter.createOrcFileWriter(sink, types);
    }

    public void writePage(Page page) {
        try {
            this.orcWriter.write(page);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.orcWriter.close();
    }

    public long getWrittenBytes() {
        return this.orcWriter.getWrittenBytes();
    }

    private static OrcWriter createOrcFileWriter(DataSink sink, List<Type> types) {
        List columnNames = (List)IntStream.range(0, types.size()).mapToObj(String::valueOf).collect(ImmutableList.toImmutableList());
        try {
            return new OrcWriter(sink, columnNames, types, OrcEncoding.ORC, CompressionKind.LZ4, Optional.empty(), DwrfEncryptionProvider.NO_ENCRYPTION, new OrcWriterOptions().withMaxStringStatisticsLimit(new DataSize(0.0, DataSize.Unit.BYTE)).withStripeMinSize(new DataSize(64.0, DataSize.Unit.MEGABYTE)).withDictionaryMaxMemory(new DataSize(1.0, DataSize.Unit.MEGABYTE)), (Map)ImmutableMap.of(), DateTimeZone.UTC, false, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());
        }
        catch (NotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
        }
    }
}

