/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.function;

import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SqlFunctionId {
    private final QualifiedFunctionName functionName;
    private final List<TypeSignature> argumentTypes;

    @JsonCreator
    public SqlFunctionId(@JsonProperty(value="functionName") QualifiedFunctionName functionName, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes) {
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.argumentTypes = Objects.requireNonNull(argumentTypes, "argumentTypes is null");
    }

    @JsonProperty
    public QualifiedFunctionName getFunctionName() {
        return this.functionName;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    public String getId() {
        return this.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlFunctionId o = (SqlFunctionId)obj;
        return Objects.equals(this.functionName, o.functionName) && Objects.equals(this.argumentTypes, o.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.argumentTypes);
    }

    public String toString() {
        String arguments = this.argumentTypes.stream().map(Object::toString).collect(Collectors.joining(", "));
        return String.format("%s(%s)", this.functionName, arguments);
    }
}

