/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.server;

import com.facebook.drift.TApplicationException;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.metadata.ThriftMethodMetadata;
import com.facebook.drift.codec.metadata.ThriftServiceMetadata;
import com.facebook.drift.server.DriftService;
import com.facebook.drift.server.MethodInvocationFilter;
import com.facebook.drift.server.ServiceMethod;
import com.facebook.drift.server.stats.MethodInvocationStat;
import com.facebook.drift.server.stats.MethodInvocationStatsFactory;
import com.facebook.drift.transport.MethodMetadata;
import com.facebook.drift.transport.server.ServerInvokeRequest;
import com.facebook.drift.transport.server.ServerMethodInvoker;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class DriftServerMethodInvoker
implements ServerMethodInvoker {
    private final Map<String, ServiceMethod> methods;
    private final Map<String, MethodInvocationStat> stats;

    public DriftServerMethodInvoker(ThriftCodecManager codecManager, Collection<DriftService> services, List<MethodInvocationFilter> filters, MethodInvocationStatsFactory methodInvocationStatsFactory) {
        HashMap<String, ServiceMethod> processorMap = new HashMap<String, ServiceMethod>();
        ImmutableMap.Builder stats = ImmutableMap.builder();
        for (DriftService service : services) {
            ThriftServiceMetadata serviceMetadata = new ThriftServiceMetadata(service.getService().getClass(), codecManager.getCatalog());
            for (ThriftMethodMetadata thriftMethodMetadata : serviceMetadata.getMethods()) {
                if (processorMap.containsKey(thriftMethodMetadata.getName())) {
                    throw new IllegalArgumentException(String.format("Multiple methods named '%s' are annotated with @ThriftMethod in the given services", thriftMethodMetadata.getName()));
                }
                ServiceMethod serviceMethod = new ServiceMethod(codecManager, service.getService(), thriftMethodMetadata, filters);
                processorMap.put(thriftMethodMetadata.getName(), serviceMethod);
                if (!service.isStatsEnabled()) continue;
                stats.put((Object)thriftMethodMetadata.getName(), (Object)methodInvocationStatsFactory.getStat(serviceMetadata, service.getQualifier(), serviceMethod.getMethodMetadata()));
            }
        }
        this.methods = ImmutableMap.copyOf(processorMap);
        this.stats = stats.build();
    }

    public Optional<MethodMetadata> getMethodMetadata(String name) {
        ServiceMethod method = this.methods.get(name);
        if (method == null) {
            return Optional.empty();
        }
        return Optional.of(method.getMethodMetadata());
    }

    public ListenableFuture<Object> invoke(ServerInvokeRequest request) {
        ServiceMethod method = this.methods.get(request.getMethod().getName());
        if (method == null) {
            return Futures.immediateFailedFuture((Throwable)new TApplicationException(TApplicationException.Type.UNKNOWN_METHOD, "Invalid method name: '" + request.getMethod().getName() + "'"));
        }
        return method.invokeMethod(request);
    }

    public void recordResult(String methodName, long startTime, ListenableFuture<Object> result) {
        MethodInvocationStat stat = this.stats.get(methodName);
        if (stat == null) {
            return;
        }
        stat.recordResult(startTime, result);
    }
}

