/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class HdfsContext {
    private final ConnectorIdentity identity;
    private final Optional<String> source;
    private final Optional<String> queryId;
    private final Optional<String> schemaName;
    private final Optional<String> tableName;
    private final Optional<String> clientInfo;

    public HdfsContext(ConnectorIdentity identity) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Optional.empty();
        this.queryId = Optional.empty();
        this.schemaName = Optional.empty();
        this.tableName = Optional.empty();
        this.clientInfo = Optional.empty();
    }

    public HdfsContext(ConnectorSession session) {
        this(session, Optional.empty(), Optional.empty());
    }

    public HdfsContext(ConnectorSession session, String schemaName) {
        this(session, Optional.of(Objects.requireNonNull(schemaName, "schemaName is null")), Optional.empty());
    }

    public HdfsContext(ConnectorSession session, String schemaName, String tableName) {
        this(session, Optional.of(Objects.requireNonNull(schemaName, "schemaName is null")), Optional.of(Objects.requireNonNull(tableName, "tableName is null")));
    }

    private HdfsContext(ConnectorSession session, Optional<String> schemaName, Optional<String> tableName) {
        Objects.requireNonNull(session, "session is null");
        this.identity = Objects.requireNonNull(session.getIdentity(), "session.getIdentity() is null");
        this.source = Objects.requireNonNull(session.getSource(), "session.getSource() is null");
        this.queryId = Optional.of(session.getQueryId());
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.clientInfo = session.getClientInfo();
    }

    public ConnectorIdentity getIdentity() {
        return this.identity;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getQueryId() {
        return this.queryId;
    }

    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    public Optional<String> getTableName() {
        return this.tableName;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("user", (Object)this.identity).add("source", this.source.orElse(null)).add("queryId", this.queryId.orElse(null)).add("schemaName", this.schemaName.orElse(null)).add("tableName", this.tableName.orElse(null)).add("clientInfo", this.clientInfo.orElse(null)).toString();
    }
}

