/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.jdbi.v3.core.argument.MethodReturnValueNamedArgumentFinder;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.ObjectPropertyNamedArgumentFinder;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class BeanPropertyArguments
extends MethodReturnValueNamedArgumentFinder {
    private static final Map<Class<?>, Map<String, PropertyDescriptor>> CLASS_PROPERTY_DESCRIPTORS = ExpiringMap.builder().expiration(10L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).entryLoader(type -> {
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            return Stream.of(info.getPropertyDescriptors()).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        }
        catch (IntrospectionException e) {
            throw new UnableToCreateStatementException("Failed to introspect object which is supposed to be used to set named args for a statement via JavaBean properties", e);
        }
    }).build();
    private final Map<String, PropertyDescriptor> propertyDescriptors;

    public BeanPropertyArguments(String prefix, Object bean) {
        super(prefix, bean);
        this.propertyDescriptors = CLASS_PROPERTY_DESCRIPTORS.get(bean.getClass());
    }

    @Override
    Optional<ObjectPropertyNamedArgumentFinder.TypedValue> getValue(String name, StatementContext ctx) {
        PropertyDescriptor descriptor = this.propertyDescriptors.get(name);
        if (descriptor == null) {
            return Optional.empty();
        }
        Method getter = this.getGetter(name, descriptor, ctx);
        Type type = getter.getGenericReturnType();
        Object value = this.invokeMethod(getter, ctx);
        return Optional.of(new ObjectPropertyNamedArgumentFinder.TypedValue(type, value));
    }

    private Method getGetter(String name, PropertyDescriptor descriptor, StatementContext ctx) {
        Method getter = descriptor.getReadMethod();
        if (getter == null) {
            throw new UnableToCreateStatementException(String.format("No getter method found for bean property [%s] on [%s]", name, this.object), ctx);
        }
        return getter;
    }

    @Override
    NamedArgumentFinder getNestedArgumentFinder(Object obj) {
        return new BeanPropertyArguments(null, obj);
    }

    public String toString() {
        return "{lazy bean property arguments \"" + this.object + "\"";
    }
}

