/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.CreateTableVerification;
import com.facebook.presto.verifier.framework.CreateViewVerification;
import com.facebook.presto.verifier.framework.DataVerification;
import com.facebook.presto.verifier.framework.DeterminismAnalyzer;
import com.facebook.presto.verifier.framework.DeterminismAnalyzerConfig;
import com.facebook.presto.verifier.framework.ExplainVerification;
import com.facebook.presto.verifier.framework.QueryType;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.Verification;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.QueryActions;
import com.facebook.presto.verifier.prestoaction.QueryActionsFactory;
import com.facebook.presto.verifier.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.verifier.resolver.FailureResolverFactoryContext;
import com.facebook.presto.verifier.resolver.FailureResolverManager;
import com.facebook.presto.verifier.resolver.FailureResolverManagerFactory;
import com.facebook.presto.verifier.rewrite.QueryRewriter;
import com.facebook.presto.verifier.rewrite.QueryRewriterFactory;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;

public class VerificationFactory {
    private final SqlParser sqlParser;
    private final QueryActionsFactory queryActionsFactory;
    private final QueryRewriterFactory queryRewriterFactory;
    private final FailureResolverManagerFactory failureResolverManagerFactory;
    private final ChecksumValidator checksumValidator;
    private final SqlExceptionClassifier exceptionClassifier;
    private final VerifierConfig verifierConfig;
    private final TypeManager typeManager;
    private final DeterminismAnalyzerConfig determinismAnalyzerConfig;
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Control/Test query thread - %d").build()));

    @Inject
    public VerificationFactory(SqlParser sqlParser, QueryActionsFactory queryActionsFactory, QueryRewriterFactory queryRewriterFactory, FailureResolverManagerFactory failureResolverManagerFactory, ChecksumValidator checksumValidator, SqlExceptionClassifier exceptionClassifier, VerifierConfig verifierConfig, TypeManager typeManager, DeterminismAnalyzerConfig determinismAnalyzerConfig) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.queryActionsFactory = Objects.requireNonNull(queryActionsFactory, "queryActionsFactory is null");
        this.queryRewriterFactory = Objects.requireNonNull(queryRewriterFactory, "queryRewriterFactory is null");
        this.failureResolverManagerFactory = Objects.requireNonNull(failureResolverManagerFactory, "failureResolverManagerFactory is null");
        this.checksumValidator = Objects.requireNonNull(checksumValidator, "checksumValidator is null");
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.verifierConfig = Objects.requireNonNull(verifierConfig, "config is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.determinismAnalyzerConfig = Objects.requireNonNull(determinismAnalyzerConfig, "determinismAnalyzerConfig is null");
    }

    public Verification get(SourceQuery sourceQuery, Optional<VerificationContext> existingContext) {
        QueryType queryType = QueryType.of(this.sqlParser.createStatement(sourceQuery.getQuery(ClusterType.CONTROL), VerifierUtil.PARSING_OPTIONS));
        VerificationContext verificationContext = existingContext.map(VerificationContext::createForResubmission).orElseGet(() -> VerificationContext.create(sourceQuery.getName(), sourceQuery.getSuite()));
        QueryActions queryActions = this.queryActionsFactory.create(sourceQuery, verificationContext);
        if (this.verifierConfig.isExplain()) {
            return new ExplainVerification(queryActions, sourceQuery, this.exceptionClassifier, verificationContext, this.verifierConfig, this.sqlParser, this.executor);
        }
        QueryRewriter queryRewriter = this.queryRewriterFactory.create(queryActions.getHelperAction());
        switch (queryType) {
            case CREATE_TABLE_AS_SELECT: 
            case INSERT: 
            case QUERY: {
                DeterminismAnalyzer determinismAnalyzer = new DeterminismAnalyzer(sourceQuery, queryActions.getHelperAction(), queryRewriter, this.checksumValidator, this.typeManager, this.determinismAnalyzerConfig);
                FailureResolverManager failureResolverManager = this.failureResolverManagerFactory.create(new FailureResolverFactoryContext(this.sqlParser, queryActions.getHelperAction()));
                return new DataVerification(queryActions, sourceQuery, queryRewriter, determinismAnalyzer, failureResolverManager, this.exceptionClassifier, verificationContext, this.verifierConfig, this.typeManager, this.checksumValidator, this.executor);
            }
            case CREATE_VIEW: {
                return new CreateViewVerification(this.sqlParser, queryActions, sourceQuery, queryRewriter, this.exceptionClassifier, verificationContext, this.verifierConfig, this.executor);
            }
            case CREATE_TABLE: {
                return new CreateTableVerification(this.sqlParser, queryActions, sourceQuery, queryRewriter, this.exceptionClassifier, verificationContext, this.verifierConfig, this.executor);
            }
        }
        throw new IllegalStateException(String.format("Unsupported query type: %s", new Object[]{queryType}));
    }
}

